/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Segment;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.crash.PlatformType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import java.util.concurrent.atomic.AtomicInteger;

public class CustomSegment
implements Segment {
    public static final int REPORT_SELF_MONITORING_EVENT = 13;
    public static final int REPORT_LIFECYCLE_EVENT = 15;
    public static final int REPORT_RAGE_TAP = 16;
    public static final int REPORT_EVENT_API = 17;
    static final int REPORT_ACTION_BEGIN = 1;
    static final int REPORT_ACTION_END = 2;
    static final int REPORT_NAMED_EVENT = 4;
    static final int REPORT_ACTION = 5;
    static final int REPORT_CUSTOM_INT_EVENT = 6;
    static final int REPORT_CUSTOM_DBL_EVENT = 7;
    static final int REPORT_CUSTOM_STR_EVENT = 8;
    static final int REPORT_ERROR_INT_EVENT = 9;
    static final int REPORT_ERROR_STR_EVENT = 10;
    static final int REPORT_CRASH_EVENT = 11;
    static final int REPORT_USER_EVENT = 12;
    static final int REPORT_ERROR_STR_EVENT_CROSS_PLATFORM = 20;
    static final int REPORT_CRASH_EVENT_CROSS_PLATFORM = 21;
    static final int ORPHAN_PLACEHOLDER = 100;
    static final int WEBREQ_PLACEHOLDER = 110;
    static AtomicInteger firstSendOccurred = new AtomicInteger(0);
    protected String mValue;
    protected long mEventStartTime = -1L;
    protected long mEventEndTime = -1L;
    protected long mParentTagId = 0L;
    protected boolean mFinalized = false;
    protected boolean enabled = true;
    protected int lcSeqNum;
    protected Session session;
    protected int serverId;
    protected EventType eventType;
    private String mName = "";
    private int mType;
    private long mCurrentTagId = 0L;
    private boolean forwardToGrail;

    public CustomSegment(String name, int type, EventType eventType, long parentTagId, int seqNumber, long startTime, long endTime, Session session, int serverId, boolean forwardToGrail) {
        this.session = session;
        this.mType = type;
        this.eventType = eventType;
        this.mEventStartTime = startTime;
        this.mEventEndTime = endTime;
        this.mParentTagId = parentTagId;
        this.mCurrentTagId = 0L;
        this.lcSeqNum = seqNumber;
        this.serverId = serverId;
        this.mFinalized = true;
        this.setName(name);
        if (parentTagId == 0L) {
            session.updateLastInteractionTime(TimeLineProvider.getSystemTime());
        }
        this.forwardToGrail = forwardToGrail;
    }

    public CustomSegment(String name, int type, EventType eventType, long parentTagId, Session session, int serverId, boolean forwardToGrail) {
        this.session = session;
        this.mType = type;
        this.eventType = eventType;
        this.mEventEndTime = this.mEventStartTime = session.getRunningTime();
        this.mParentTagId = parentTagId;
        this.mCurrentTagId = Utility.getNextTagId();
        this.lcSeqNum = Utility.getEventSeqNum();
        this.serverId = serverId;
        this.mFinalized = type != 5;
        this.setName(name);
        if (parentTagId == 0L) {
            session.updateLastInteractionTime(TimeLineProvider.getSystemTime());
        }
        this.forwardToGrail = forwardToGrail;
    }

    public CustomSegment(String name, int type, Session session, int serverId, boolean forwardToGrail) {
        this.mType = type;
        this.mCurrentTagId = Utility.getNextTagId();
        this.session = session;
        this.serverId = serverId;
        this.setName(name);
        this.forwardToGrail = forwardToGrail;
    }

    public void disable() {
        this.enabled = false;
        this.mFinalized = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected boolean nameMissing() {
        return this.mName == null || this.mName.isEmpty();
    }

    protected long getSessionRunningTime() {
        return this.session.getRunningTime();
    }

    protected void updateEndTime(long endTime) {
        if (!this.mFinalized) {
            this.mEventEndTime = endTime;
            this.mFinalized = true;
            if (this.mParentTagId == 0L) {
                this.session.updateLastInteractionTime(TimeLineProvider.getSystemTime());
            }
        }
    }

    protected void updateEndTime() {
        long value = this.getOverrideEndTime();
        if (value > 0L) {
            this.updateEndTime(value);
        } else {
            this.updateEndTime(this.getSessionRunningTime());
        }
    }

    public String getName() {
        return this.mName;
    }

    protected void setName(String name) {
        this.mName = name == null ? "" : Utility.truncateString((String)name, (int)250);
    }

    protected long getOverrideEndTime() {
        return 0L;
    }

    public boolean isFinalized() {
        return this.mFinalized;
    }

    public long getTagId() {
        return this.mCurrentTagId;
    }

    public long getParentTagId() {
        return this.mParentTagId;
    }

    protected void setParentTagId(long parentTagId) {
        this.mParentTagId = parentTagId;
    }

    protected int getType() {
        return this.mType;
    }

    public long getStartTime() {
        return this.mEventStartTime;
    }

    public void setStartTime(long newStartTime) {
        this.mEventStartTime = newStartTime;
    }

    protected long getEndTime() {
        return this.mEventEndTime;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public int getLcSeqNum() {
        return this.lcSeqNum;
    }

    public void setLcSeqNum(int seqNum) {
        this.lcSeqNum = seqNum;
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.eventType.getProtocolId());
        switch (this.eventType) {
            case VALUE_DOUBLE: {
                this.generateCustomMessage(sb);
                sb.append("&vl=").append(Utility.urlEncode((String)this.mValue));
                break;
            }
            case VALUE_STRING: {
                this.generateCustomMessage(sb);
                this.appendOptionalValue(sb, "&vl=", Utility.urlEncode((String)this.mValue));
                break;
            }
            case VALUE_INT64: {
                this.generateCustomMessage(sb);
                sb.append("&vl=").append(Utility.urlEncode((String)this.mValue));
                break;
            }
            case NAMED_EVENT: {
                this.generateCustomMessage(sb);
                break;
            }
            case IDENTIFY_USER: {
                this.generateCustomMessage(sb);
                break;
            }
            case ERROR_INT: {
                this.generateCustomMessage(sb);
                sb.append("&ev=").append(Utility.urlEncode((String)this.mValue));
                sb.append("&tt=").append(PlatformType.CUSTOM.getProtocolValue());
                break;
            }
            case SELF_MONITORING_EVENT: {
                sb.append("&na=").append(Utility.urlEncode((String)this.getName()));
                this.appendOptionalValue(sb, "&pl=", Utility.urlEncode((String)this.mValue));
                sb.append("&t0=").append(this.getStartTime());
            }
        }
        sb.append("&fw=").append(this.forwardToGrail ? "1" : "0");
        return sb;
    }

    private void generateCustomMessage(StringBuilder sb) {
        sb.append("&na=").append(Utility.urlEncode((String)this.getName()));
        sb.append("&it=").append(Thread.currentThread().getId());
        sb.append("&pa=").append(this.getParentTagId());
        sb.append("&s0=").append(this.getLcSeqNum());
        sb.append("&t0=").append(this.getStartTime());
    }

    protected void appendOptionalValue(StringBuilder stringBuilder, String key, String value) {
        if (value != null) {
            stringBuilder.append(key);
            if (!value.isEmpty()) {
                stringBuilder.append(value);
            }
        }
    }

    public int getServerId() {
        return this.serverId;
    }

    public Session getSession() {
        return this.session;
    }
}

