/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.ragetap;

import com.dynatrace.android.agent.events.ragetap.RageTapSegment;
import com.dynatrace.android.agent.util.Utility;

public class RageTapEventWriter {
    private static final String DELIMITER = "&";
    private static final String ASSIGN = "=";
    private static final String EVENT_TYPE = "et=";
    private static final String NAME = "na";
    private static final String SEQUENCE_NUMBER = "s0";
    private static final String TIME_FIRST_TAP_DOWN = "t0";
    private static final String TIME_LAST_TAP_UP = "t1";
    private static final String NUMBER_OF_TAPS = "nt";
    private static final String FORWARD_MESSAGE = "fw";

    public StringBuilder toBeaconString(RageTapSegment rageTapSegment) {
        StringBuilder sb = new StringBuilder();
        sb.append(EVENT_TYPE).append(rageTapSegment.getEventType().getProtocolId());
        if (rageTapSegment.getActivityName() != null) {
            sb.append(DELIMITER).append(NAME).append(ASSIGN).append(Utility.urlEncode((String)rageTapSegment.getName()));
        }
        sb.append(DELIMITER).append(SEQUENCE_NUMBER).append(ASSIGN).append(rageTapSegment.getLcSeqNum());
        sb.append(DELIMITER).append(TIME_FIRST_TAP_DOWN).append(ASSIGN).append(rageTapSegment.getFirstTapDown());
        sb.append(DELIMITER).append(TIME_LAST_TAP_UP).append(ASSIGN).append(rageTapSegment.getLastTapUp());
        sb.append(DELIMITER).append(NUMBER_OF_TAPS).append(ASSIGN).append(rageTapSegment.getNumOfTaps());
        sb.append(DELIMITER).append(FORWARD_MESSAGE).append(ASSIGN).append(rageTapSegment.getForwardToGrail() ? "1" : "0");
        return sb;
    }
}

