/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.List;

public class CalloutTable {
    private static final String TAG = Global.LOG_PREFIX + "CalloutTable";
    private long mSendTimeout;
    private long mCurrentTimeout;
    private List<CTElement> mTable = new ArrayList<CTElement>();

    public CalloutTable(int sendTimeout) {
        this.mSendTimeout = sendTimeout;
        this.mCurrentTimeout = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionEvent(CustomSegment segment) {
        if (segment == null) {
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)String.format("Add segment %s (id=%d pid=%d) currTimeout=%s", segment.getName() + segment.hashCode(), segment.getTagId(), segment.getParentTagId(), this.mCurrentTimeout));
        }
        List<CTElement> list = this.mTable;
        synchronized (list) {
            long timeout = this.mSendTimeout - this.mCurrentTimeout;
            for (int i = 0; i < this.mTable.size(); ++i) {
                if (this.mTable.get(i).timeout >= timeout) {
                    this.mTable.get(i).timeout -= timeout;
                    this.mTable.add(i, new CTElement(segment, timeout));
                    return;
                }
                timeout -= this.mTable.get(i).timeout;
            }
            this.mTable.add(new CTElement(segment, timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherEvent() {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            if (this.mTable.size() > 0) {
                return;
            }
            if (this.mCurrentTimeout == 0L) {
                this.mCurrentTimeout = this.mSendTimeout;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeActionSendEvent(CustomSegment segment) {
        if (segment == null) {
            return false;
        }
        String id = segment.getName() + segment.hashCode();
        List<CTElement> list = this.mTable;
        synchronized (list) {
            for (int i = 0; i < this.mTable.size(); ++i) {
                if (!this.mTable.get(i).actionId.equals(id)) continue;
                if (i + 1 < this.mTable.size()) {
                    this.mTable.get(i + 1).timeout += this.mTable.get(i).timeout;
                } else if (this.mCurrentTimeout == 0L) {
                    this.mCurrentTimeout = this.mTable.get(i).timeout;
                }
                CTElement obj = this.mTable.remove(i);
                return obj != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSendEventTimeout(long newTimeout) {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            if (newTimeout == this.mSendTimeout) {
                return;
            }
            this.mSendTimeout = newTimeout;
            if (this.mCurrentTimeout > newTimeout) {
                if (this.mTable.size() > 0) {
                    this.mTable.get(0).timeout += this.mCurrentTimeout - newTimeout;
                }
                this.mCurrentTimeout = newTimeout;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isItTimeToSend() {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            if (this.mCurrentTimeout > 0L) {
                boolean bl = --this.mCurrentTimeout == 0L;
                return bl;
            }
            if (this.mTable.size() > 0 && --this.mTable.get(0).timeout == 0L) {
                do {
                    this.mTable.remove(0);
                } while (this.mTable.size() > 0 && this.mTable.get(0).timeout == 0L);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            this.mTable.clear();
            this.mCurrentTimeout = 0L;
        }
    }

    public String toString() {
        String s = this.mCurrentTimeout + ";";
        for (int i = 0; i < this.mTable.size(); ++i) {
            s = s + this.mTable.get(i).timeout + ";";
        }
        return s;
    }

    private class CTElement {
        private String actionId;
        private long timeout;

        public CTElement(CustomSegment segment, long timeout) {
            this.actionId = segment.getName() + segment.hashCode();
            this.timeout = timeout;
        }
    }
}

