/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.location.Location;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.Version;
import com.dynatrace.android.agent.comm.MonitoringDataPacket;
import com.dynatrace.android.agent.conf.InstrumentationFlavor;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.UserPrivacyOptions;
import com.dynatrace.android.agent.crash.CrashCatcher;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.agent.metrics.AppVersion;
import com.dynatrace.android.agent.metrics.ConnectionType;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;
import java.util.Locale;

public class BasicSegment {
    private static final String TAG = Global.LOG_PREFIX + "BasicSegment";
    private static final int MAX_VERSION_NAME_LENGTH = 50;
    private static final String DEV_ORIENT_P = "p";
    private static final String DEV_ORIENT_L = "l";
    private static final String DEV_GENUINE = "g";
    private static final String DEV_ROOTED = "r";
    private static final String CRASH_REP_LEVEL_OFF = "0";
    private static final String CRASH_REP_LEVEL_DISCONFIRMED = "1";
    private static final String CRASH_REP_LEVEL_CONFIRMED = "2";
    private static final long OCUPDT_STALE = 5000L;
    protected AndroidMetrics metrics = AndroidMetrics.getInstance();
    protected String mockDeviceLocation = "";
    protected Long mtsOcUpdt = 0L;
    private final InstrumentationFlavor instrumentationFlavor;

    protected BasicSegment(InstrumentationFlavor instrumentationFlavor) {
        this.instrumentationFlavor = instrumentationFlavor;
    }

    public static boolean addNewVisitorInfoToDataChunk(MonitoringDataPacket data) {
        for (String eventData : data.events) {
            if (!eventData.contains("&pa=0")) continue;
            data.basicData = data.basicData + "&nu=" + CRASH_REP_LEVEL_DISCONFIRMED;
            return true;
        }
        return false;
    }

    public void update(boolean updateAllValues) {
        Long tsDelta;
        if (updateAllValues) {
            this.metrics.updateBasicMetrics();
        }
        if ((tsDelta = Long.valueOf(TimeLineProvider.getSystemTime() - this.mtsOcUpdt)) <= 5000L) {
            return;
        }
        this.mtsOcUpdt = TimeLineProvider.getSystemTime();
        this.metrics.updateCommonMetrics();
    }

    public StringBuilder createEventData(Session session) {
        StringBuilder sb = new StringBuilder();
        ScreenMetrics screenMetrics = this.metrics.getScreenMetrics();
        sb.append("vv=").append("3");
        sb.append("&va=").append(Version.getFullVersion());
        sb.append("&ap=").append(AdkSettings.appIdEncoded);
        sb.append("&an=").append(Utility.urlEncode((String)AdkSettings.applName));
        sb.append("&ai=").append(Utility.urlEncode((String)AdkSettings.applIdentifier));
        AppVersion appVersion = this.metrics.getAppVersion();
        if (appVersion == null) {
            sb.append("&vb=").append(0);
        } else {
            sb.append("&vb=").append(appVersion.getVersionCode());
            if (appVersion.getVersionName() != null) {
                String trimmedVersionName = Utility.truncateString((String)appVersion.getVersionName(), (int)50);
                sb.append("&vn=").append(Utility.urlEncode((String)trimmedVersionName));
            }
        }
        sb.append("&vi=").append(session.visitorId);
        sb.append("&sn=").append(session.sessionId);
        sb.append("&ss=").append(session.sequenceNumber);
        sb.append("&rm=").append(this.metrics.deviceMemorySize);
        sb.append("&cp=").append(Utility.urlEncode((String)this.metrics.cpuInformation));
        sb.append("&os=").append(Utility.urlEncode((String)this.metrics.operatingSystem));
        sb.append("&mf=").append(Utility.urlEncode((String)Utility.truncateString((String)(this.metrics.manufacturer != null ? this.metrics.manufacturer : "unknown"), (int)250)));
        sb.append("&md=").append(Utility.urlEncode((String)this.metrics.modelId));
        sb.append("&rj=").append(this.metrics.deviceRooted ? DEV_ROOTED : DEV_GENUINE);
        sb.append("&ul=").append(this.metrics.userLang);
        if (screenMetrics != null) {
            if (screenMetrics.getScreenWidth() > screenMetrics.getScreenHeight()) {
                sb.append("&sw=").append(screenMetrics.getScreenHeight());
                sb.append("&sh=").append(screenMetrics.getScreenWidth());
            } else {
                sb.append("&sw=").append(screenMetrics.getScreenWidth());
                sb.append("&sh=").append(screenMetrics.getScreenHeight());
            }
            sb.append("&sd=").append(screenMetrics.getScreenDensityDpi());
        }
        sb.append("&pt=").append(CRASH_REP_LEVEL_OFF);
        String orientation = null;
        if (this.metrics.deviceOrientation == 2) {
            orientation = DEV_ORIENT_L;
        } else if (this.metrics.deviceOrientation == 1) {
            orientation = DEV_ORIENT_P;
        }
        if (orientation != null) {
            sb.append("&so=").append(orientation);
        }
        if (this.metrics.batteryLevel >= 0) {
            sb.append("&bl=").append(this.metrics.batteryLevel);
        }
        if (this.metrics.deviceMemoryFree != null) {
            sb.append("&fm=").append(this.metrics.deviceMemoryFree);
        }
        if (this.metrics.deviceCarrier != null) {
            sb.append("&cr=").append(Utility.urlEncode((String)this.metrics.deviceCarrier));
        }
        if (this.metrics.connectionType != ConnectionType.OTHER) {
            sb.append("&ct=").append(this.metrics.connectionType.getProtocolValue());
            if (this.metrics.networkProtocol != null && this.metrics.networkProtocol.length() > 0) {
                sb.append("&np=").append(Utility.urlEncode((String)this.metrics.networkProtocol));
            }
        }
        PrivacyRules privacyRules = session.getPrivacyRules();
        if (this.mockDeviceLocation != null && this.mockDeviceLocation.length() > 0 && privacyRules.allowLocationReporting()) {
            sb.append("&lx=").append(Utility.urlEncode((String)this.mockDeviceLocation));
        }
        sb.append("&tt=").append("maandroid");
        sb.append("&dl=").append(privacyRules.getPrivacySettings().getDataCollectionLevel().ordinal());
        sb.append("&cl=").append(this.determineCrashReportingLevel(privacyRules.getPrivacySettings()));
        sb.append("&fv=").append(this.instrumentationFlavor.getProtocolValue());
        return sb;
    }

    private String determineCrashReportingLevel(UserPrivacyOptions privacySettings) {
        if (!CrashCatcher.registered) {
            return CRASH_REP_LEVEL_OFF;
        }
        return privacySettings.isCrashReportingOptedIn() ? CRASH_REP_LEVEL_CONFIRMED : CRASH_REP_LEVEL_DISCONFIRMED;
    }

    public void setGpsLocation(Location location) {
        this.mockDeviceLocation = location != null ? String.format(Locale.US, "%3.3fx%3.3f", location.getLatitude(), location.getLongitude()) : "";
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("GPS/Network getLastKnownLocation mockDeviceLocation:" + this.mockDeviceLocation));
        }
    }

    public static class UpdatableDataGenerator {
        public String generateUpdatableData(long sessionStartFromClusterTimeLine, int multiplicity, String srBasicParam) {
            StringBuilder sb = new StringBuilder();
            sb.append("&tv=").append(sessionStartFromClusterTimeLine);
            sb.append("&tx=").append("__tsNow__");
            sb.append("&mp=");
            sb.append(multiplicity < 0 ? 1 : multiplicity);
            if (srBasicParam != null) {
                sb.append("&sr=").append(srBasicParam);
            }
            return sb.toString();
        }
    }
}

