/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.crash;

import com.dynatrace.android.agent.crash.PlatformType;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.crash.StacktraceProcessor;
import com.dynatrace.android.agent.util.Utility;

public class XamarinStacktraceProcessor
implements StacktraceProcessor {
    private static final String XAMARIN_AT = "  at ";
    private static final String EXCEPTION_MSG_DELIMITER = " ---> ";
    private final String exception;
    private final int maxLines;
    private final int maxStacktraceSize;
    private final int maxReasonLength;
    private final int maxLength;

    public XamarinStacktraceProcessor(String exception, int maxLines) {
        this(exception, maxLines, 128000, 1000, 250);
    }

    XamarinStacktraceProcessor(String exception, int maxLines, int maxStacktraceSize, int maxReasonLength, int maxLength) {
        this.exception = exception;
        this.maxLines = maxLines;
        this.maxStacktraceSize = maxStacktraceSize;
        this.maxReasonLength = maxReasonLength;
        this.maxLength = maxLength;
    }

    private static boolean isXamarin(String exception) {
        for (String line : exception.split("\n")) {
            if (!line.startsWith(XAMARIN_AT)) continue;
            return true;
        }
        return false;
    }

    public static String convertToXamarinOrNull(Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            String message = t.getMessage();
            if (message == null || !XamarinStacktraceProcessor.isXamarin(message)) continue;
            return message;
        }
        return null;
    }

    @Override
    public StacktraceData process() {
        String[] lines = this.exception.split("\n");
        if (lines.length < 1) {
            throw new IllegalArgumentException("no lines");
        }
        if (lines[0].startsWith(XAMARIN_AT)) {
            throw new IllegalArgumentException("no reason message available");
        }
        int index = lines[0].indexOf(":");
        if (index < 0) {
            throw new IllegalArgumentException("no exception name available");
        }
        String name = Utility.truncateString(lines[0].substring(0, index), this.maxLength);
        String reason = this.generateReason(lines, this.maxReasonLength);
        String stacktrace = this.generateStackTrace(lines);
        return new StacktraceData(name, reason, stacktrace, PlatformType.XAMARIN);
    }

    private String generateReason(String[] lines, int maxReasonSize) {
        StringBuilder sb = new StringBuilder();
        int indexDelimiter = lines[0].indexOf(EXCEPTION_MSG_DELIMITER);
        if (indexDelimiter >= 0) {
            sb.append(lines[0].substring(0, indexDelimiter));
        } else {
            sb.append(lines[0]);
            for (int ii = 1; ii < lines.length && !lines[ii].startsWith(XAMARIN_AT) && sb.length() < maxReasonSize; ++ii) {
                sb.append("\n");
                indexDelimiter = lines[ii].indexOf(EXCEPTION_MSG_DELIMITER);
                if (indexDelimiter >= 0) {
                    sb.append(lines[ii].substring(0, indexDelimiter));
                    break;
                }
                sb.append(lines[ii]);
            }
        }
        if (sb.length() > maxReasonSize) {
            return sb.substring(0, maxReasonSize);
        }
        return sb.toString();
    }

    private String generateStackTrace(String[] lines) {
        if (lines.length <= this.maxLines && this.exception.length() <= this.maxStacktraceSize) {
            return this.exception;
        }
        StringBuilder sb = new StringBuilder();
        int stacktraceSize = 0;
        for (int ii = 0; ii < Math.min(lines.length, this.maxLines); ++ii) {
            int lineBreak;
            int n = lineBreak = ii == 0 ? 0 : 1;
            if (stacktraceSize + lines[ii].length() + lineBreak > this.maxStacktraceSize) break;
            if (lineBreak > 0) {
                sb.append("\n");
            }
            sb.append(lines[ii]);
            stacktraceSize += lines[ii].length() + lineBreak;
        }
        return sb.toString();
    }
}

