/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import android.content.Context;
import android.content.SharedPreferences;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.DataCollectionLevel;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.ServerConfigurationManager;
import com.dynatrace.android.agent.conf.UserPrivacyOptions;
import com.dynatrace.android.agent.util.Utility;
import org.json.JSONException;

public class PreferencesManager {
    private static final String SHARED_PREFERENCES = "com.dynatrace.android.dtxPref";
    private static final String TAG = Global.LOG_PREFIX + "PreferencesManager";
    private static final String KEY_NEW_VISITOR_SENT = "DTXNewVisitorSent";
    private static final String KEY_DATA_COLLECTION_LEVEL = "DTXDataCollectionLevel";
    private static final String KEY_OPT_IN_CRASHES = "DTXOptInCrashes";
    private static final String KEY_REPLAY_CRASHES = "DTXCrashReplayOptedIn";
    @Deprecated
    private static final String KEY_BEACON = "DTX_BeaconSignal";
    private static final String KEY_SERVER_CONFIG = "ServerConfig";
    private final SharedPreferences sharedPreferences;
    private final ServerConfigurationManager serverConfigurationManager;

    PreferencesManager(SharedPreferences sharedPreferences, ServerConfigurationManager serverConfigurationManager) {
        this.sharedPreferences = sharedPreferences;
        this.serverConfigurationManager = serverConfigurationManager;
    }

    public static PreferencesManager createPreferencesManager(Context context, ServerConfigurationManager serverConfigManager) {
        return new PreferencesManager(context.getSharedPreferences(SHARED_PREFERENCES, 0), serverConfigManager);
    }

    public boolean getNewVisitorFlag() {
        return this.loadPrefValue(KEY_NEW_VISITOR_SENT, true);
    }

    public void setNewVisitorSent(boolean newValue) {
        this.sharedPreferences.edit().putBoolean(KEY_NEW_VISITOR_SENT, newValue).apply();
    }

    @Deprecated
    public String getBeacon() {
        return this.loadPrefValue(KEY_BEACON, "dynaTraceMonitor");
    }

    @Deprecated
    public void setBeacon(String beacon) {
        if ("dynaTraceMonitor".equals(beacon)) {
            this.removeBeacon();
            return;
        }
        this.sharedPreferences.edit().putString(KEY_BEACON, beacon).apply();
    }

    @Deprecated
    public void removeBeacon() {
        this.sharedPreferences.edit().remove(KEY_BEACON).apply();
    }

    public UserPrivacyOptions readPrivacySettings() {
        UserPrivacyOptions noValueDefined = PrivacyRules.NO_USER_DEFINED_VALUE;
        try {
            boolean crashReportingOptedIn = this.sharedPreferences.getBoolean(KEY_OPT_IN_CRASHES, noValueDefined.isCrashReportingOptedIn());
            DataCollectionLevel dataCollectionLevel = DataCollectionLevel.valueOf(this.sharedPreferences.getString(KEY_DATA_COLLECTION_LEVEL, noValueDefined.getDataCollectionLevel().name()));
            boolean crashReplayOptedIn = this.sharedPreferences.getBoolean(KEY_REPLAY_CRASHES, noValueDefined.isCrashReportingOptedIn());
            if (!crashReportingOptedIn && crashReplayOptedIn) {
                this.sharedPreferences.edit().putBoolean(KEY_REPLAY_CRASHES, false).apply();
                crashReplayOptedIn = false;
                if (Global.DEBUG) {
                    Utility.zlogE(TAG, "CrashReplayOptedIn cannot be true when CrashReportOptIn is false");
                }
            }
            return new UserPrivacyOptions.Builder().withDataCollectionLevel(dataCollectionLevel).withCrashReportingOptedIn(crashReportingOptedIn).withCrashReplayOptedIn(crashReplayOptedIn).build();
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "could not read privacy settings", e);
            }
            this.removePrivacySettings();
            return noValueDefined;
        }
    }

    public void storePrivacySettings(UserPrivacyOptions privacySettings) {
        this.sharedPreferences.edit().putBoolean(KEY_OPT_IN_CRASHES, privacySettings.isCrashReportingOptedIn()).putString(KEY_DATA_COLLECTION_LEVEL, privacySettings.getDataCollectionLevel().name()).putBoolean(KEY_REPLAY_CRASHES, privacySettings.isCrashReplayOptedIn()).apply();
    }

    public void removePrivacySettings() {
        this.sharedPreferences.edit().remove(KEY_OPT_IN_CRASHES).remove(KEY_DATA_COLLECTION_LEVEL).remove(KEY_REPLAY_CRASHES).apply();
    }

    private ServerConfiguration prepareConfiguration(ServerConfiguration configuration, int defaultServerId) {
        ServerConfiguration.Builder builder = configuration != null ? configuration.newBuilder() : new ServerConfiguration.Builder().withServerId(defaultServerId);
        return builder.withTimestamp(0L).withCapture(1).withMultiplicity(1).withSwitchServer(false).withTrafficControlPercentage(-1).build();
    }

    private ServerConfiguration readConfiguration() {
        if (!this.sharedPreferences.contains(KEY_SERVER_CONFIG)) {
            return null;
        }
        String json = this.loadPrefValue(KEY_SERVER_CONFIG, null);
        if (Global.DEBUG) {
            Utility.zlogD(TAG, "stored configuration: " + json);
        }
        try {
            return this.serverConfigurationManager.fromMemory(json);
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "can't parse stored configuration", e);
            }
            this.removeServerConfiguration();
            return null;
        }
    }

    public ServerConfiguration getServerConfiguration(int defaultServerId) {
        return this.prepareConfiguration(this.readConfiguration(), defaultServerId);
    }

    public void setServerConfiguration(ServerConfiguration serverConfig) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        try {
            editor.putString(KEY_SERVER_CONFIG, this.serverConfigurationManager.generateStorableConfiguration(serverConfig));
        }
        catch (JSONException e) {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "unable to generate configuration", e);
            }
            editor.remove(KEY_SERVER_CONFIG);
        }
        editor.apply();
    }

    public void removeServerConfiguration() {
        this.sharedPreferences.edit().remove(KEY_SERVER_CONFIG).apply();
    }

    private String loadPrefValue(String key, String defaultValue) {
        try {
            return this.sharedPreferences.getString(key, defaultValue);
        }
        catch (ClassCastException e) {
            this.sharedPreferences.edit().remove(key).apply();
            return defaultValue;
        }
    }

    private boolean loadPrefValue(String key, boolean defaultValue) {
        try {
            return this.sharedPreferences.getBoolean(key, defaultValue);
        }
        catch (ClassCastException e) {
            this.sharedPreferences.edit().remove(key).apply();
            return defaultValue;
        }
    }
}

