/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.os.SystemClock;
import java.util.concurrent.TimeUnit;

public class TimeLineProvider {
    private static final long DEVICE_START_TIME_MS = System.currentTimeMillis() - SystemClock.elapsedRealtime();
    public static TimeLineProvider globalTimeLineProvider = new TimeLineProvider();
    private final long deviceStartTimeMillis;
    private final long deviceStartTimeNanos;

    public TimeLineProvider() {
        this(DEVICE_START_TIME_MS);
    }

    public TimeLineProvider(long deviceStartTimeMillis) {
        this.deviceStartTimeMillis = deviceStartTimeMillis;
        this.deviceStartTimeNanos = TimeUnit.MILLISECONDS.toNanos(deviceStartTimeMillis);
    }

    public static long getSystemTime() {
        return globalTimeLineProvider.now();
    }

    public static long getSystemTimeNanos() {
        return globalTimeLineProvider.nowNanos();
    }

    public long now() {
        return this.deviceStartTimeMillis + SystemClock.elapsedRealtime();
    }

    public long nowNanos() {
        return this.deviceStartTimeNanos + SystemClock.elapsedRealtimeNanos();
    }
}

