/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.ragetap.measure;

import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Window;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.ragetap.detection.RageTapDetector;
import com.dynatrace.android.ragetap.measure.MotionEventConverter;
import com.dynatrace.android.ragetap.measure.TapMonitor;
import com.dynatrace.android.window.OnTouchEventListener;
import com.dynatrace.android.window.WindowListenerFactory;

public class TapMonitorFactory
implements WindowListenerFactory {
    private final RageTapDetector detector;
    private final TimeLineProvider timeLineProvider;

    public TapMonitorFactory(RageTapDetector detector, TimeLineProvider timeLineProvider) {
        this.detector = detector;
        this.timeLineProvider = timeLineProvider;
    }

    @Override
    public OnTouchEventListener generateOnTouchEventListener(Window window) {
        MotionEventConverter converter = new MotionEventConverter(TapMonitorFactory.measureScreenDensity(window));
        return new TapMonitor(this.detector, converter, this.timeLineProvider);
    }

    private static float measureScreenDensity(Window window) {
        if (Build.VERSION.SDK_INT >= 30) {
            DisplayMetrics metrics = new DisplayMetrics();
            window.getContext().getDisplay().getRealMetrics(metrics);
            return metrics.density;
        }
        return AndroidMetrics.getInstance().screenDensity;
    }
}

