/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import java.util.List;

public class ProcessAnalyzer {
    private static final String WORKER_PROCESS_NAME = ":dynatrace_replay_service";
    private final Context context;

    public ProcessAnalyzer(Context context) {
        this.context = context;
    }

    public boolean isInternalProcess() {
        return this.isInternalProcess(Process.myPid());
    }

    public boolean isInternalProcess(int pid) {
        String name = this.getProcessNameOrNull(pid);
        if (name == null) {
            return false;
        }
        return name.contains(WORKER_PROCESS_NAME);
    }

    String getProcessNameOrNull(int pid) {
        ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
        if (manager == null) {
            return null;
        }
        List processes = manager.getRunningAppProcesses();
        if (processes == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo processInfo : processes) {
            if (processInfo.pid != pid) continue;
            return processInfo.processName;
        }
        return null;
    }
}

