/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.lifecycle.DisplayEventWriter;
import com.dynatrace.android.agent.measurement.MeasurementPoint;

public class DisplaySegment
extends CustomSegment {
    private final MeasurementPoint createEvent;
    private final MeasurementPoint startEvent;
    private final MeasurementPoint resumeEvent;
    private final MeasurementPoint endPoint;

    private DisplaySegment(Builder builder) {
        super(builder.lifecycleOwner, 15, builder.session, builder.serverId);
        this.eventType = builder.eventType;
        this.lcSeqNum = builder.actionCreationPoint.getSequenceNumber();
        this.mEventStartTime = builder.actionCreationPoint.getTimestamp();
        this.mParentTagId = builder.parentActionId;
        this.createEvent = builder.createEvent;
        this.startEvent = builder.startEvent;
        this.resumeEvent = builder.resumeEvent;
        this.endPoint = builder.endpoint;
        this.mFinalized = true;
    }

    public MeasurementPoint getActionCreationPoint() {
        return new MeasurementPoint(this.getStartTime(), this.lcSeqNum);
    }

    public MeasurementPoint getCreateEvent() {
        return this.createEvent;
    }

    public MeasurementPoint getStartEvent() {
        return this.startEvent;
    }

    public MeasurementPoint getResumeEvent() {
        return this.resumeEvent;
    }

    public MeasurementPoint getEndpoint() {
        return this.endPoint;
    }

    @Override
    protected int getType() {
        return super.getType();
    }

    @Override
    public StringBuilder createEventData() {
        return new DisplayEventWriter().toBeaconString(this);
    }

    public static class Builder {
        private String lifecycleOwner;
        private Session session;
        private int serverId;
        private long parentActionId;
        private EventType eventType;
        private MeasurementPoint actionCreationPoint;
        private MeasurementPoint createEvent;
        private MeasurementPoint startEvent;
        private MeasurementPoint resumeEvent;
        private MeasurementPoint endpoint;

        public Builder withLifecycleOwner(String lifecycleOwner) {
            this.lifecycleOwner = lifecycleOwner;
            return this;
        }

        public Builder withSession(Session session) {
            this.session = session;
            return this;
        }

        public Builder withServerId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withActionCreationPoint(MeasurementPoint actionCreationPoint) {
            this.actionCreationPoint = actionCreationPoint;
            return this;
        }

        public Builder withCreateEvent(MeasurementPoint createEvent) {
            this.createEvent = createEvent;
            return this;
        }

        public Builder withStartEvent(MeasurementPoint startEvent) {
            this.startEvent = startEvent;
            return this;
        }

        public Builder withResumeEvent(MeasurementPoint resumeEvent) {
            this.resumeEvent = resumeEvent;
            return this;
        }

        public Builder withEndPoint(MeasurementPoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withParentActionId(long parentActionId) {
            this.parentActionId = parentActionId;
            return this;
        }

        public Builder withEventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public DisplaySegment build() {
            return new DisplaySegment(this);
        }
    }
}

