/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.crash;

import com.dynatrace.android.agent.crash.PlatformType;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.crash.StacktraceProcessor;
import com.dynatrace.android.agent.util.Utility;

public class JavaStacktraceProcessor
implements StacktraceProcessor {
    private static final String AT = "\tat ";
    private final Throwable throwable;
    private final int maxLines;
    private final int maxStacktraceLength;
    private final int maxReasonLength;
    private final int maxLength;

    public JavaStacktraceProcessor(Throwable throwable, int maxLines) {
        this(throwable, maxLines, 128000, 1000, 250);
    }

    JavaStacktraceProcessor(Throwable throwable, int maxLines, int maxStacktraceLength, int maxReasonLength, int maxLength) {
        this.throwable = throwable;
        this.maxLines = maxLines;
        this.maxStacktraceLength = maxStacktraceLength;
        this.maxReasonLength = maxReasonLength;
        this.maxLength = maxLength;
    }

    @Override
    public StacktraceData process() {
        String name = Utility.trimString(this.throwable.getClass().getName(), this.maxLength);
        String reason = Utility.trimString(this.throwable.toString(), this.maxReasonLength);
        String stacktrace = this.generateStackTrace();
        return new StacktraceData(name, reason, stacktrace, PlatformType.JAVA);
    }

    private String generateStackTrace() {
        String causedBy = "\nCaused by: ";
        int causedByLength = causedBy.length();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int prevStacktraceSize = 0;
        int stacktraceSize = 0;
        for (Throwable theCause = this.throwable; theCause != null && count < this.maxLines && stacktraceSize <= this.maxStacktraceLength; theCause = theCause.getCause()) {
            String trimmedReason;
            String[] trimmedReasonLines;
            if (count > 0) {
                sb.append(causedBy);
                stacktraceSize += causedByLength;
            }
            if ((trimmedReasonLines = (trimmedReason = this.trimStackTraceReason(theCause.toString(), prevStacktraceSize, count > 0)).split("\n")).length > this.maxLines - count) {
                int i = 0;
                while (count < this.maxLines) {
                    if (i > 0) {
                        sb.append("\n");
                    }
                    sb.append(trimmedReasonLines[i]);
                    stacktraceSize = sb.length();
                    ++count;
                    ++i;
                }
                break;
            }
            sb.append(trimmedReason);
            stacktraceSize = sb.length();
            count += trimmedReasonLines.length;
            prevStacktraceSize = stacktraceSize;
            stacktraceSize = sb.length();
            StackTraceElement[] trace = theCause.getStackTrace();
            if (trace == null) continue;
            int lineCount = Math.min(trace.length, this.maxLines - count);
            for (int i = 0; i < lineCount && stacktraceSize < this.maxStacktraceLength; ++i) {
                sb.append("\n").append(AT).append(trace[i]);
                prevStacktraceSize = stacktraceSize;
                stacktraceSize = sb.length();
                ++count;
            }
        }
        if (stacktraceSize > this.maxStacktraceLength) {
            return sb.substring(0, prevStacktraceSize).trim();
        }
        return sb.toString().trim();
    }

    private String trimStackTraceReason(String reason, int stackTraceSize, boolean includeCausedBy) {
        if (reason == null) {
            return "";
        }
        int sizeLeft = Math.max(0, this.maxStacktraceLength - stackTraceSize - (includeCausedBy ? 12 : 0));
        int maxLength = Math.min(sizeLeft, this.maxReasonLength);
        if (reason.length() > maxLength) {
            return reason.substring(0, maxLength);
        }
        return reason;
    }
}

