/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.cookie;

import android.content.Context;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

class CookieWriter {
    private static final String LOG_TAG = Global.LOG_PREFIX + "CookieWriter";
    private Context context;
    private CookieManager cookieManager;

    CookieWriter(Context context) {
        this.context = context;
        this.init();
    }

    private void init() {
        block4: {
            try {
                CookieManager.setAcceptFileSchemeCookies((boolean)true);
                if (Build.VERSION.SDK_INT < 21) {
                    CookieSyncManager.createInstance((Context)this.context);
                    CookieSyncManager.getInstance();
                }
                if (!CookieManager.getInstance().acceptCookie()) {
                    CookieManager.getInstance().setAcceptCookie(true);
                }
                this.cookieManager = CookieManager.getInstance();
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block4;
                Utility.zlogE(LOG_TAG, "unable to access CookieManager", e);
            }
        }
    }

    void writeCookies(Set<String> domains, Collection<String> cookies) {
        if (this.cookieManager == null) {
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOG_TAG, "domains: " + domains.toString());
            Utility.zlogD(LOG_TAG, "cookies: " + cookies.toString());
        }
        for (String domain : domains) {
            for (String cookie : cookies) {
                this.cookieManager.setCookie(domain, cookie);
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
    }

    void removeCookies(Set<String> domains, Collection<String> cookieNames) {
        ArrayList<String> cookies = new ArrayList<String>();
        for (String domain : domains) {
            for (String cookieName : cookieNames) {
                cookies.add(cookieName + "=; Max-Age=-1");
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
        this.writeCookies(domains, cookies);
    }
}

