/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuilderUtil {
    static String truncateString(String value) {
        if (value != null && (value = value.trim()).length() > 0) {
            return value;
        }
        return null;
    }

    static String[] truncateStrings(String value, String delimiter) {
        if (value == null) {
            return null;
        }
        return BuilderUtil.truncateStrings(value.split(delimiter));
    }

    static String[] truncateStrings(String[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> acceptedParts = new ArrayList<String>();
        for (String part : values) {
            String trimmed;
            if (part == null || (trimmed = part.trim()).length() <= 0) continue;
            acceptedParts.add(trimmed);
        }
        if (acceptedParts.size() > 0) {
            return acceptedParts.toArray(new String[acceptedParts.size()]);
        }
        return null;
    }

    static String getVerifiedBeaconUrl(String beaconUrl, boolean mustHavePath) {
        String beaconUrlTruncated = BuilderUtil.truncateString(beaconUrl);
        if (beaconUrlTruncated == null) {
            return null;
        }
        Pattern urlPattern = Pattern.compile("^(https?://)?([^\\s/$.?#](?::?[^\\s?]*\\@)?[^\\s/:?]*(?::[\\d]+)?)(?:/|$)([^\\s?]*)");
        Matcher partMatcher = urlPattern.matcher(beaconUrlTruncated);
        partMatcher.find();
        if (!partMatcher.matches()) {
            return null;
        }
        String schema = partMatcher.group(1);
        String domain = partMatcher.group(2);
        String path = partMatcher.group(3);
        if (domain == null || domain.isEmpty()) {
            return null;
        }
        if (mustHavePath && (path == null || path.isEmpty())) {
            return null;
        }
        StringBuilder verifiedBeaconURL = new StringBuilder();
        verifiedBeaconURL.append(schema == null ? "https://" : schema);
        verifiedBeaconURL.append(domain);
        if (path != null && !path.isEmpty()) {
            verifiedBeaconURL.append("/");
            if (path.endsWith("/")) {
                verifiedBeaconURL.append(path, 0, path.length() - 1);
            } else {
                verifiedBeaconURL.append(path);
            }
        }
        return verifiedBeaconURL.toString();
    }
}

