/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.data.Session;

class SelfMonitoring {
    SelfMonitoring() {
    }

    static void reportLogEvent(String eventName, String eventPayload) {
        if (eventName == null || eventName.isEmpty()) {
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        AdkSettings adkSettings = AdkSettings.getInstance();
        if (!adkSettings.getServerConfiguration().isSelfmonitoring()) {
            return;
        }
        if (adkSettings.getConfiguration().mode == AgentMode.APP_MON) {
            return;
        }
        Session session = Session.determineActiveSessionForInternalEvent();
        if (session.isSelfMonitoringLimitReached()) {
            return;
        }
        int serverId = adkSettings.serverId;
        CustomSegment customSegment = Core.addEvent(eventName, 13, 0L, null, session, serverId, eventPayload);
        if (customSegment != null) {
            session.addSelfMonitoringEvent();
        }
    }
}

