/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.os.Build;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class RootDetector {
    private static final String LOGTAG = Global.LOG_PREFIX + "RootDetector";
    private static final String TEST_KEYS = "test-keys";
    private static final File SU_APK = new File("/system/app/Superuser.apk");
    private static final String[] WHICH_SU = new String[]{"/system/xbin/which", "su"};

    public static boolean isDeviceRooted() {
        return RootDetector.checkTestKeys() || RootDetector.checkSuperuserFiles() || RootDetector.checkSuBinary();
    }

    private static boolean checkSuBinary() {
        Process p;
        try {
            p = Runtime.getRuntime().exec(WHICH_SU);
        }
        catch (Exception e) {
            return false;
        }
        BufferedReader in = null;
        try {
            String thisLine;
            ArrayList<String> response = new ArrayList<String>();
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((thisLine = in.readLine()) != null) {
                response.add(thisLine);
            }
            return response.size() > 0;
        }
        catch (Exception e) {
            block9: {
                if (Global.DEBUG) {
                    Utility.zlogE(LOGTAG, "unable to read response from 'which' command", e);
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        if (!Global.DEBUG) break block9;
                        Utility.zlogE(LOGTAG, "unable to close stream", ex);
                    }
                }
            }
            return false;
        }
    }

    private static boolean checkSuperuserFiles() {
        try {
            return SU_APK.exists();
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogE(LOGTAG, SU_APK.toString(), e);
            }
            return false;
        }
    }

    private static boolean checkTestKeys() {
        String tags = Build.TAGS;
        return tags != null && tags.contains(TEST_KEYS);
    }
}

