/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.ModifiableUserAction;
import com.dynatrace.android.agent.util.Utility;

class ExposedUserAction
implements ModifiableUserAction {
    private static final String TAG = Global.LOG_PREFIX + "ExposedUserAction";
    private final DTXAutoAction autoAction;

    ExposedUserAction(DTXAutoAction autoAction) {
        this.autoAction = autoAction;
    }

    @Override
    public String getActionName() {
        return this.autoAction.getName();
    }

    @Override
    public void setActionName(String actionName) {
        if (actionName == null || actionName.isEmpty()) {
            Utility.zlogD(TAG, "The action name cannot be changed to an empty String or null");
            return;
        }
        if (!this.isActionClosed()) {
            this.autoAction.setName(actionName);
        }
    }

    @Override
    public void reportEvent(String eventName) {
        if (this.actionCanTakeEvents()) {
            this.autoAction.reportEvent(eventName);
        }
    }

    @Override
    public void reportValue(String valueName, int value) {
        if (this.actionCanTakeEvents()) {
            this.autoAction.reportValue(valueName, value);
        }
    }

    @Override
    public void reportValue(String valueName, long value) {
        if (this.actionCanTakeEvents()) {
            this.autoAction.reportValue(valueName, value);
        }
    }

    @Override
    public void reportValue(String valueName, double value) {
        if (this.actionCanTakeEvents()) {
            this.autoAction.reportValue(valueName, value);
        }
    }

    @Override
    public void reportValue(String valueName, String value) {
        if (this.actionCanTakeEvents()) {
            this.autoAction.reportValue(valueName, value);
        }
    }

    @Override
    public void reportError(String errorName, int errorCode) {
        if (this.actionCanTakeEvents()) {
            this.autoAction.reportError(errorName, errorCode);
        }
    }

    @Override
    public void reportError(String errorName, Throwable throwable) {
        if (this.actionCanTakeEvents()) {
            this.autoAction.reportError(errorName, throwable);
        }
    }

    private boolean isActionClosed() {
        if (this.autoAction.isFinalized()) {
            Utility.zlogD(TAG, "The action cannot be modified since it is already closed");
            return true;
        }
        return false;
    }

    private boolean actionCanTakeEvents() {
        if (this.isActionClosed()) {
            return false;
        }
        if (this.autoAction.isGraceTimeOver()) {
            Utility.zlogD(TAG, "The action cannot be modified since its grace time passed");
            return false;
        }
        return true;
    }
}

