/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.ActionThreadLocal;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CrashReporter;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXAction;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.crash.JavaStacktraceProcessor;
import com.dynatrace.android.agent.crash.PlatformType;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.intf.DTXActionListener;
import com.dynatrace.android.agent.util.Utility;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DTXActionImpl
extends CustomSegment
implements DTXAction {
    public static final int MAX_DEPTH = 10;
    private static final String LOGTAG = Global.LOG_PREFIX + "DTXActionImpl";
    private static final String DEPTH_WARNING = "Maximum depth of actions reached (10). Discarding creation of '%s'";
    private static CopyOnWriteArrayList<DTXActionListener> actionListeners = null;
    private static ConcurrentHashMap<Long, Vector<CustomSegment>> orphanEvents = new ConcurrentHashMap();
    protected int endActionSequenceNum = -1;
    protected Vector<CustomSegment> childEventVector = new Vector();
    protected DTXActionImpl parentAction = null;
    int numberOfParentActions = 0;

    protected DTXActionImpl(String name, EventType eventType, long parentTagId, Session session, int serverId) {
        super(name, 5, eventType, parentTagId, session, serverId);
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "New action " + name);
        }
        if (this.nameMissing()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("The action name is null or empty hence this action will be deactivated", new Object[0]));
            }
            this.disable();
        }
    }

    static void registerActionListener(DTXActionListener listener) {
        int idx;
        if (listener == null) {
            return;
        }
        if (actionListeners == null) {
            actionListeners = new CopyOnWriteArrayList();
        }
        if ((idx = actionListeners.indexOf(listener)) < 0) {
            actionListeners.add(listener);
        }
    }

    static void removeActionListener(DTXActionListener listener) {
        if (listener == null || actionListeners == null) {
            return;
        }
        actionListeners.remove(listener);
    }

    protected static DTXAction createAction(String actionName, DTXAction pAction) {
        int serverId;
        Session session;
        long parentTagId = 0L;
        DTXActionImpl parentAction = null;
        if (pAction instanceof DTXActionImpl) {
            parentAction = (DTXActionImpl)pAction;
        }
        if (parentAction != null && !parentAction.isFinalized()) {
            parentTagId = parentAction.getTagId();
            session = parentAction.session;
            serverId = parentAction.serverId;
        } else {
            session = Session.determineActiveSession(false, true);
            serverId = AdkSettings.getInstance().serverId;
        }
        DTXActionImpl action = new DTXActionImpl(actionName, EventType.ACTION_MANUAL, parentTagId, session, serverId);
        if (parentAction != null && parentAction.isFinished()) {
            action.disable();
        }
        if (parentTagId != 0L) {
            action.parentAction = parentAction;
            action.numberOfParentActions = parentAction.numberOfParentActions + 1;
            parentAction.addChildEvent(action);
            if (action.numberOfParentActions >= 10) {
                if (Global.DEBUG) {
                    Utility.zlogW(LOGTAG, String.format(DEPTH_WARNING, action.getName()));
                }
                return action;
            }
        }
        ActionThreadLocal.addAction(action);
        Core.addEvent(actionName, 1, parentTagId, action, session, serverId, new String[0]);
        return action;
    }

    @Deprecated
    static void addOrphanEvent(CustomSegment event) {
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && conf.mode == AgentMode.SAAS) {
            return;
        }
        Vector<CustomSegment> orphanVector = orphanEvents.get(Thread.currentThread().getId());
        if (orphanVector == null) {
            orphanVector = new Vector();
            orphanEvents.put(Thread.currentThread().getId(), orphanVector);
        }
        orphanVector.add(event);
    }

    @Deprecated
    static Vector<CustomSegment> getOrphanEvents() {
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && conf.mode == AgentMode.SAAS) {
            return null;
        }
        return orphanEvents.remove(Thread.currentThread().getId());
    }

    @Override
    public void leaveAction() {
        this.leaveAction(true);
    }

    public void discardAction() {
        this.leaveAction(false);
    }

    protected void leaveAction(boolean shouldStoreAction) {
        if (this.isFinalized()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("Action %s is already closed", this.getName()));
            }
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("Action %s closing ... saving=%b", this.getName(), shouldStoreAction));
        }
        ActionThreadLocal.removeAction(this);
        boolean rc = this.getPreconditions();
        if (rc) {
            this.mEventEndTime = this.session.getRunningTime();
            this.adoptOrphans();
            this.leaveInnerActions(shouldStoreAction);
            this.endActionSequenceNum = Utility.getEventSeqNum();
            if (shouldStoreAction) {
                Core.addEvent(this.getName(), 2, this.getParentTagId(), this, this.session, this.serverId, new String[0]);
            } else {
                this.updateEndTime();
                Core.removeFromCalloutTable(this);
            }
        } else {
            this.leaveInnerActions(false);
            this.updateEndTime();
            Core.removeFromCalloutTable(this);
        }
        if (actionListeners != null) {
            ActionLeaveNotification aln = new ActionLeaveNotification(new ArrayList<DTXActionListener>(actionListeners), this);
            if (CrashReporter.hasCrashed()) {
                aln.notifyActionLeave();
            } else {
                aln.start();
            }
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("Action %s closed: shouldSave=%b rc=%b listener=%d", this.getName(), shouldStoreAction, rc, actionListeners == null ? 0 : actionListeners.size()));
            if (!rc) {
                Utility.zlogW(LOGTAG, String.format("Discard %s tagId=%d capture state=%b", this.getName(), this.getTagId(), rc));
            }
        }
    }

    @Override
    public final void reportEvent(String eventName) {
        this.addChildEvent(eventName, 4, new String[0]);
    }

    @Override
    public final void reportValue(String valueName, int value) {
        this.addChildEvent(valueName, 6, String.valueOf(value));
    }

    @Override
    public final void reportValue(String valueName, long value) {
        this.addChildEvent(valueName, 6, String.valueOf(value));
    }

    @Override
    public final void reportValue(String valueName, double value) {
        this.addChildEvent(valueName, 7, String.valueOf(value));
    }

    @Override
    public final void reportValue(String valueName, String value) {
        this.addChildEvent(valueName, 8, value);
    }

    @Override
    public final void reportError(String errorName, int errorCode) {
        this.addChildEvent(errorName, 9, String.valueOf(errorCode));
    }

    @Override
    public final void reportError(String errorName, Throwable throwable) {
        if (errorName == null) {
            return;
        }
        if (!this.getPreconditions()) {
            return;
        }
        int maxLines = AdkSettings.getInstance().getConfiguration().mode == AgentMode.APP_MON ? 10 : Integer.MAX_VALUE;
        StacktraceData stacktraceData = throwable == null ? new StacktraceData(null, null, null, PlatformType.JAVA) : new JavaStacktraceProcessor(throwable, maxLines).process();
        this.addChildEvent(errorName, 10, stacktraceData.getName(), stacktraceData.getReason(), stacktraceData.getStacktrace(), stacktraceData.getType().getProtocolValue());
    }

    @Override
    public final boolean isFinished() {
        return this.isFinalized();
    }

    @Override
    public final void cancel() {
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "Action '" + this.getName() + "' was canceled by the developer");
        }
        this.discardAction();
    }

    void reportError(PlatformType type, String errorName, String errorValue, String reason, String stacktrace) {
        if (type == null || errorName == null) {
            return;
        }
        this.addChildEvent(errorName, 10, Utility.trimString(errorValue, 250), Utility.trimString(reason, 1000), Utility.trimString(stacktrace, 128000), type.getProtocolValue());
    }

    @Deprecated
    void reportCrash(PlatformType type, String crashName, String reason, String stacktrace) {
        Dynatrace.reportCrash(type, crashName, reason, stacktrace);
    }

    @Override
    public void tagRequest(HttpURLConnection conn) {
        this.internalTagRequest(conn);
    }

    WebReqTag internalTagRequest(HttpURLConnection conn) {
        WebReqTag wrTag;
        block4: {
            if (conn == null) {
                return null;
            }
            wrTag = this.internalTagRequest();
            if (wrTag == null) {
                return null;
            }
            String tagStr = wrTag.toString();
            try {
                conn.setRequestProperty(Dynatrace.getRequestTagHeader(), tagStr);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block4;
                Utility.zlogE(LOGTAG, e.toString());
            }
        }
        return wrTag;
    }

    public String tagRequest() {
        return WebReqTag.tagToString(this.internalTagRequest());
    }

    WebReqTag internalTagRequest() {
        WebReqTag wrTag = this.getInternalRequestTag();
        if (wrTag == null) {
            return null;
        }
        CustomSegment seg = new CustomSegment(wrTag.toString(), 110, EventType.PLACEHOLDER, this.getTagId(), this.session, this.serverId);
        this.addChildEvent(seg);
        return wrTag;
    }

    @Override
    public final String getRequestTagHeader() {
        return Dynatrace.getRequestTagHeader();
    }

    @Override
    public String getRequestTag() {
        return WebReqTag.tagToString(this.getInternalRequestTag());
    }

    protected WebReqTag getInternalRequestTag() {
        if (!this.getPreconditions() || !this.session.getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
            return null;
        }
        return new WebReqTag(this.getTagId(), this.serverId, this.session);
    }

    public final void addChildEvent(CustomSegment childEvent) {
        if (childEvent == null || !childEvent.isEnabled()) {
            return;
        }
        this.childEventVector.add(childEvent);
        this.notifyChildAdded(childEvent);
    }

    private void addChildEvent(String eventName, int type, String ... values) {
        if (!this.getPreconditions()) {
            return;
        }
        CustomSegment cs = Core.addEvent(eventName, type, this.getTagId(), null, this.session, this.serverId, values);
        if (cs != null) {
            this.addChildEvent(cs);
        }
    }

    protected boolean getPreconditions() {
        if (this.isFinalized()) {
            return false;
        }
        if (this.numberOfParentActions >= 10) {
            if (Global.DEBUG) {
                Utility.zlogW(LOGTAG, String.format(DEPTH_WARNING, this.getName()));
            }
            return false;
        }
        return Dynatrace.getCaptureStatus();
    }

    @Deprecated
    protected void adoptOrphans() {
        Vector<CustomSegment> orphanVector = DTXActionImpl.getOrphanEvents();
        if (orphanVector == null) {
            return;
        }
        for (CustomSegment orphan : orphanVector) {
            if (orphan.getStartTime() > this.getStartTime() && orphan.getStartTime() < this.getEndTime()) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, String.format("%s adopting %s tagId=%s", this.getName(), orphan.getName(), orphan.getTagId()));
                }
                orphan.setParentTagId(this.getTagId());
                this.addChildEvent(orphan);
                continue;
            }
            if (!Global.DEBUG) continue;
            Utility.zlogD(LOGTAG, String.format("%s not adopting %s tagId=%s", this.getName(), orphan.getName(), orphan.getTagId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leaveInnerActions(boolean shouldStoreAction) {
        if (this.childEventVector == null) {
            return;
        }
        Vector<CustomSegment> vector = this.childEventVector;
        synchronized (vector) {
            for (int i = this.childEventVector.size() - 1; i >= 0; --i) {
                CustomSegment item = this.childEventVector.get(i);
                if (item.getType() != 5) continue;
                ((DTXActionImpl)item).leaveAction(shouldStoreAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<CustomSegment> getChildEventVector() {
        Vector<CustomSegment> vector = this.childEventVector;
        synchronized (vector) {
            return new Vector<CustomSegment>(this.childEventVector);
        }
    }

    public void removeChildEvent(String childName) {
        if (childName == null) {
            return;
        }
        for (CustomSegment cs : this.getChildEventVector()) {
            if (!cs.getName().equals(childName)) continue;
            this.childEventVector.remove(cs);
            Core.removeFromCalloutTable(cs);
            if (!Global.DEBUG) break;
            Utility.zlogD(LOGTAG, "Removing child: " + childName);
            break;
        }
    }

    protected void notifyChildAdded(CustomSegment childEvent) {
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.eventType.getProtocolId());
        sb.append("&na=").append(Utility.urlEncode(this.getName()));
        sb.append("&it=").append(Thread.currentThread().getId());
        sb.append("&ca=").append(this.getTagId());
        sb.append("&pa=").append(this.getParentTagId());
        sb.append("&s0=").append(this.getLcSeqNum());
        sb.append("&t0=").append(this.getStartTime());
        sb.append("&s1=").append(this.endActionSequenceNum);
        sb.append("&t1=").append(this.getEndTime() - this.getStartTime());
        return sb;
    }

    public int getNumberOfParentActions() {
        return this.numberOfParentActions;
    }

    private class ActionLeaveNotification
    extends Thread {
        private ArrayList<DTXActionListener> listeners;
        private DTXActionImpl action;

        ActionLeaveNotification(ArrayList<DTXActionListener> listeners, DTXActionImpl action) {
            this.listeners = listeners;
            this.action = action;
        }

        @Override
        public void run() {
            this.notifyActionLeave();
        }

        private void notifyActionLeave() {
            for (DTXActionListener listener : this.listeners) {
                listener.onLeaveAction(this.action);
            }
            this.listeners.clear();
            this.listeners = null;
            this.action = null;
        }
    }
}

