/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.util.Utility;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ConnectionAttemptMonitor {
    private static final String TAG = Global.LOG_PREFIX + "ConnectionAttemptMonitor";
    private static final long ONE_MINUTE = 60000L;
    private static final long THIRTY_TWO_MINUTE = 1920000L;
    private static final long FIFTY_SEVEN_MINUTE = 3420000L;
    private long initialConnAttempts;
    private long nextAttemptTime;
    private Timer timer;
    private boolean onceConnected;
    private boolean lastConnected;
    private AtomicBoolean timeToConnect;
    private Date currentWhen;

    ConnectionAttemptMonitor(int initialConnAttempts) {
        if (initialConnAttempts < 1) {
            throw new IllegalArgumentException("Connection attempts must be greater than zero");
        }
        this.initialConnAttempts = ++initialConnAttempts;
        this.timeToConnect = new AtomicBoolean(true);
        this.nextAttemptTime = 0L;
        this.setTimer(this.getNextAttemptTime());
    }

    boolean reconnAttemptInProgress() {
        return this.onceConnected && !this.lastConnected && this.nextAttemptTime > 0L;
    }

    synchronized void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    synchronized void setTimer(Date when) {
        block4: {
            this.cancelTimer();
            this.currentWhen = when;
            if (this.currentWhen != null) {
                this.timer = new Timer(TAG);
                try {
                    this.timer.schedule((TimerTask)new AttemptTimer(), this.currentWhen);
                    if (Global.DEBUG) {
                        Utility.zlogD(TAG, "Connection attempt is scheduled for " + this.currentWhen);
                    }
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block4;
                    Utility.zlogD(TAG, "Failed to schedule a connection attempt ... " + e.toString());
                }
            }
        }
    }

    protected synchronized void restartTimer() {
        this.setTimer(this.currentWhen);
    }

    private Date getNextAttemptTime() {
        Date when = new Date(TimeLineProvider.getSystemTime() + this.nextAttemptTime);
        --this.initialConnAttempts;
        if (this.initialConnAttempts > 0L) {
            this.nextAttemptTime = 60000L;
        } else if (this.initialConnAttempts == 0L) {
            this.nextAttemptTime = 0L;
            when = null;
        } else if (this.nextAttemptTime == 1920000L) {
            this.nextAttemptTime = 3420000L;
        } else if (this.nextAttemptTime == 3420000L) {
            when = null;
        } else if (this.nextAttemptTime > 0L) {
            this.nextAttemptTime *= 2L;
        } else {
            when = null;
        }
        return when;
    }

    boolean isTimeToConnect() {
        return this.timeToConnect.getAndSet(false);
    }

    synchronized boolean moreAttemptsAllowed() {
        if (this.timeToConnect.get()) {
            return true;
        }
        return this.lastConnected || this.timer != null || this.initialConnAttempts > 0L && this.nextAttemptTime < 3420000L;
    }

    public synchronized void stop() {
        this.lastConnected = false;
        this.timeToConnect.set(false);
        if (Global.DEBUG) {
            Utility.zlogD(TAG, "Connection stop notification");
        }
        this.cancelTimer();
    }

    public synchronized void notifyStateTooManyRequests(int delay) {
        this.lastConnected = false;
        this.timeToConnect.set(false);
        if (this.onceConnected && this.timer == null && this.nextAttemptTime == 0L) {
            this.nextAttemptTime = 60000L;
        }
        if (this.timer != null || this.getNextAttemptTime() != null) {
            this.setTimer(new Date(TimeLineProvider.getSystemTime() + (long)(delay * 1000)));
        }
    }

    public synchronized void notifyConnectionState(boolean connected, boolean restartTimer) {
        this.lastConnected = connected;
        this.timeToConnect.set(false);
        if (connected) {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "Connection ok notification");
            }
            this.onceConnected = true;
            this.initialConnAttempts = -1L;
            this.nextAttemptTime = 0L;
            this.cancelTimer();
        } else {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "No connection notification");
            }
            if (this.onceConnected && this.timer == null && this.nextAttemptTime == 0L) {
                this.nextAttemptTime = 60000L;
                this.setTimer(this.getNextAttemptTime());
            } else if (restartTimer && this.timer == null) {
                this.setTimer(this.getNextAttemptTime());
            }
        }
    }

    private class AttemptTimer
    extends TimerTask {
        private AttemptTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionAttemptMonitor connectionAttemptMonitor = ConnectionAttemptMonitor.this;
            synchronized (connectionAttemptMonitor) {
                ConnectionAttemptMonitor.this.timeToConnect.set(true);
                ConnectionAttemptMonitor.this.setTimer(ConnectionAttemptMonitor.this.getNextAttemptTime());
            }
        }
    }
}

