/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.os.Looper;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.AgentStateListener;
import com.dynatrace.android.agent.BasicSegment;
import com.dynatrace.android.agent.CalloutTable;
import com.dynatrace.android.agent.ConnectionAttemptMonitor;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.comm.CommHandler;
import com.dynatrace.android.agent.comm.CommunicationProblemListener;
import com.dynatrace.android.agent.comm.CommunicationProblemListenerTask;
import com.dynatrace.android.agent.comm.HttpResponse;
import com.dynatrace.android.agent.comm.InvalidResponseException;
import com.dynatrace.android.agent.comm.MonitoringDataPacket;
import com.dynatrace.android.agent.comm.RequestExecutor;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.ServerConfigurationManager;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.db.DataAccessObject;
import com.dynatrace.android.agent.db.DatabaseWriteQueue;
import com.dynatrace.android.agent.db.MonitoringDataEntity;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.agent.util.Utility;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CommunicationManager {
    private static final int COMM_MAX_RETRIES = 3;
    private static final String TAG = Global.LOG_PREFIX + "CommunicationManager";
    protected DataAccessObject dao;
    RequestExecutor requestExecutor;
    BasicSegment.UpdatableDataGenerator updatableDataGenerator = new BasicSegment.UpdatableDataGenerator();
    TimeLineProvider timeLineProvider = TimeLineProvider.globalTimeLineProvider;
    private WriteLock writeLock;
    private AtomicBoolean mForceUemUpdate = new AtomicBoolean(false);
    private AtomicBoolean mForceSendEvent = new AtomicBoolean(false);
    private AtomicBoolean mUemActive = new AtomicBoolean(false);
    private Thread mtEventSender;
    private Timer mtTimer;
    private ConnectionAttemptMonitor connAttemptMonitor;
    private boolean mEventSenderActive = false;
    private long uemLastUpdate = 0L;
    private CalloutTable calloutTable;
    private CommunicationProblemListener communicationProblemListener;
    private ThreadPoolExecutor executor;
    private AgentStateListener agentStateListener = null;

    CommunicationManager(CalloutTable calloutTable) {
        this.calloutTable = calloutTable;
        this.writeLock = new WriteLock();
    }

    void startup(DataAccessObject dao, Configuration configuration, AgentStateListener agentStateListener) {
        block4: {
            this.dao = dao;
            this.agentStateListener = agentStateListener;
            this.communicationProblemListener = configuration.communicationProblemListener;
            dao.deleteOldEvents(this.timeLineProvider.now(), AdkSettings.getInstance().getServerConfiguration().isCachingCrashes());
            if (this.communicationProblemListener != null) {
                this.executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            }
            this.requestExecutor = new RequestExecutor(new CommHandler(), configuration, new ServerConfigurationManager(configuration.appIdEncoded));
            if (this.mtEventSender != null && this.mtEventSender.isAlive()) {
                try {
                    this.mtEventSender.interrupt();
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block4;
                    Utility.zlogE(TAG, "event sender thread problem", e);
                }
            }
        }
        this.mtEventSender = new EventSenderThread();
        this.mtEventSender.start();
        this.mUemActive.set(true);
    }

    synchronized void startTimerLoop(boolean freshStart) {
        if (this.mtTimer != null) {
            return;
        }
        if (freshStart || this.connAttemptMonitor == null) {
            this.connAttemptMonitor = new ConnectionAttemptMonitor(3);
        } else {
            this.connAttemptMonitor.restartTimer();
        }
        this.mtTimer = new Timer(TAG);
        this.mtTimer.schedule((TimerTask)new DataSendTimerTask(), this.mEventSenderActive ? 0L : 100L, 10000L);
    }

    protected synchronized void stopTimerLoop() {
        if (this.mtTimer != null) {
            this.mtTimer.cancel();
            this.mtTimer.purge();
        }
        this.mtTimer = null;
        this.calloutTable.purge();
        if (this.connAttemptMonitor != null) {
            this.connAttemptMonitor.cancelTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SendState sendMonitoringData(ServerConfiguration currentServerConfig, long curVisitorId) {
        if (!this.writeLock.available()) {
            return SendState.NO_DATA;
        }
        try {
            boolean outstandingData;
            MonitoringDataEntity monitoringDataEntity;
            long now = this.timeLineProvider.now();
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "sendMonitoringData begin @" + now);
            }
            DatabaseWriteQueue.getInstance().flushQueue();
            this.dao.deleteOldEvents(now, currentServerConfig.isCachingCrashes());
            if (currentServerConfig.isCachingCrashes()) {
                this.dao.deleteOldCrashes(currentServerConfig.getMaxCachedCrashesCount());
            }
            if ((monitoringDataEntity = this.dao.fetchEvents(currentServerConfig.maxSendLength(), this.updatableDataGenerator, now)) == null) {
                SendState sendState = SendState.NO_DATA;
                return sendState;
            }
            boolean evaluateNewVisitorFlag = monitoringDataEntity.visitorId == curVisitorId;
            boolean successfully = this.handleSendEvents(currentServerConfig, monitoringDataEntity.monitoringData, monitoringDataEntity.serverId, evaluateNewVisitorFlag, monitoringDataEntity.visitorId, monitoringDataEntity.sessionId, outstandingData = !monitoringDataEntity.finished);
            if (!successfully) {
                SendState sendState = SendState.DATA_NOT_SENT;
                return sendState;
            }
            this.dao.deleteSentEvents(monitoringDataEntity);
            SendState sendState = monitoringDataEntity.finished ? SendState.FINISHED : SendState.MORE_DATA_AVAILABLE;
            return sendState;
        }
        finally {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "sendMonitoringData end @" + this.timeLineProvider.now());
            }
            this.writeLock.release();
        }
    }

    private boolean handleSendEvents(ServerConfiguration currentServerConfig, MonitoringDataPacket monitoringData, int serverId, boolean evaluateNewVisitorFlag, long visitorId, long sessionId, boolean outstandingData) {
        boolean newVisitorRequest = false;
        try {
            if (!AdkSettings.getInstance().newVisitorSent.get() && !AdkSettings.getInstance().newVisitorSentPending.get() && evaluateNewVisitorFlag && (newVisitorRequest = BasicSegment.addNewVisitorInfoToDataChunk(monitoringData))) {
                AdkSettings.getInstance().newVisitorSentPending.set(true);
            }
            ServerConfiguration newServerConfig = this.requestExecutor.sendData(currentServerConfig, monitoringData.generatePayload(), serverId, visitorId, sessionId, outstandingData);
            if (newVisitorRequest) {
                AdkSettings.getInstance().setNewVisitorSent(true);
                AdkSettings.getInstance().newVisitorSentPending.set(false);
            }
            this.handleConfigReceived(currentServerConfig, newServerConfig);
            return true;
        }
        catch (Exception e) {
            if (newVisitorRequest) {
                AdkSettings.getInstance().newVisitorSentPending.set(false);
            }
            if (Global.DEBUG) {
                this.logRequestError("data request failed", e);
            }
            this.handleRequestError(e);
            return false;
        }
    }

    private void forceUemStateUpdate(ServerConfiguration currentServerConfig, Session session) {
        boolean changeFlagValue = true;
        this.dao.deleteOldEvents(this.timeLineProvider.now(), currentServerConfig.isCachingCrashes());
        try {
            boolean requireConfig = !session.isConfigurationApplied();
            ServerConfiguration newServerConfig = this.requestExecutor.sendBeacon(currentServerConfig, requireConfig, AdkSettings.getInstance().serverId, session);
            this.handleConfigReceived(currentServerConfig, newServerConfig);
            if (requireConfig) {
                session.handleTrafficLimitation(newServerConfig.getTrafficControlPercentage(), newServerConfig.getMultiplicity(), this.agentStateListener);
                if (!session.isActive()) {
                    this.dao.deleteEventsFromVisit(session.visitorId, session.sessionId);
                } else {
                    this.updateMultiplicityForEvents(session);
                }
                Core.handleTrafficLimitationForCookies(session);
            }
            Session newSession = Session.currentSession();
            changeFlagValue = newSession.isConfigurationApplied();
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                this.logRequestError("beacon request failed", e);
            }
            this.handleRequestError(e);
        }
        if (changeFlagValue) {
            this.mForceUemUpdate.set(false);
        }
        if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("UEM state update: UEM state: %b mForceUemUpdate: %b", this.mUemActive.get(), this.mForceUemUpdate.get()));
        }
    }

    private void logRequestError(String errorMsg, Exception exception) {
        if (exception instanceof UnknownHostException) {
            Utility.zlogD(TAG, errorMsg);
            Utility.zlogD(TAG, exception.toString());
        } else {
            Utility.zlogD(TAG, errorMsg, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEvents() {
        Thread thread = this.mtEventSender;
        synchronized (thread) {
            this.mForceSendEvent.set(true);
            this.mtEventSender.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleNewBeaconRequest() {
        Thread thread = this.mtEventSender;
        synchronized (thread) {
            this.mForceUemUpdate.set(true);
            this.mtEventSender.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(long lStopTimeLimitSec) {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.mUemActive.set(false);
        Thread eventSender = this.mtEventSender;
        if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("Shutdown allocated time: %s ms threadId=%s", lStopTimeLimitSec, eventSender.getId()));
        }
        long lTsStopInit = this.timeLineProvider.now();
        Thread thread = eventSender;
        synchronized (thread) {
            this.mForceSendEvent.set(true);
            this.mEventSenderActive = false;
            eventSender.notify();
        }
        if (eventSender.isAlive()) {
            block10: {
                try {
                    eventSender.join(lStopTimeLimitSec);
                }
                catch (InterruptedException e) {
                    if (!Global.DEBUG) break block10;
                    Utility.zlogE(TAG, String.format("Thread to send final events Interrupted, allotted time: %s ms", lStopTimeLimitSec), e);
                }
            }
            if (eventSender.isAlive() && Global.DEBUG) {
                Utility.zlogE(TAG, String.format("Thread to send final events didn't complete in allotted time:%s ms", lStopTimeLimitSec));
            }
        }
        this.requestExecutor.resetBeaconRetries();
        if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("Shutdown took: %s ms threadID=%s", this.timeLineProvider.now() - lTsStopInit, eventSender.getId()));
        }
    }

    private void handleConfigReceived(ServerConfiguration oldServerConfig, ServerConfiguration newServerConfig) {
        this.mUemActive.set(newServerConfig.isCaptureOn());
        if (newServerConfig.getStatus() == ServerConfiguration.Status.ERROR) {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "Received faulty settings that will turn the agent off");
            }
        } else {
            AdkSettings.getInstance().preferencesManager.setServerConfiguration(newServerConfig);
        }
        Core.applyServerConfiguration(newServerConfig);
        if (this.agentStateListener != null) {
            if (newServerConfig.getTimestamp() > oldServerConfig.getTimestamp()) {
                this.agentStateListener.onServerConfigurationChanged(newServerConfig);
            }
            if (newServerConfig.isSwitchServer()) {
                this.agentStateListener.onServerIdForceChanged(newServerConfig.getServerId());
            }
        }
        if (this.mtTimer != null && this.connAttemptMonitor != null) {
            this.connAttemptMonitor.notifyConnectionState(true, false);
        }
    }

    private void handleRequestError(Exception exception) {
        block11: {
            if (exception instanceof InvalidResponseException) {
                List<String> values;
                InvalidResponseException ire = (InvalidResponseException)exception;
                HttpResponse response = ire.getResponse();
                if (response.responseCode == 429 && (values = response.headers.get("Retry-After")) != null && !values.isEmpty()) {
                    try {
                        int delaySec = Integer.parseInt(values.get(0));
                        this.mUemActive.set(false);
                        DatabaseWriteQueue.getInstance().flushQueue();
                        Core.dao.deleteAllEvents();
                        if (this.connAttemptMonitor != null) {
                            this.connAttemptMonitor.notifyStateTooManyRequests(delaySec);
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!Global.DEBUG) break block11;
                        Utility.zlogE(TAG, "can't parse Retry-After header", e);
                    }
                }
            }
        }
        if (this.communicationProblemListener == null) {
            this.handleRequestError(false);
        } else {
            if (exception instanceof InvalidResponseException) {
                this.mUemActive.set(false);
                if (this.mtTimer != null && this.connAttemptMonitor != null) {
                    this.connAttemptMonitor.stop();
                }
            } else {
                this.handleRequestError(true);
            }
            if (!this.executor.isShutdown()) {
                this.executor.execute(new CommunicationProblemListenerTask(this.communicationProblemListener, exception));
            }
        }
    }

    private void handleRequestError(boolean restartTimer) {
        this.mUemActive.set(false);
        if (this.mtTimer != null && this.connAttemptMonitor != null) {
            this.connAttemptMonitor.notifyConnectionState(false, restartTimer);
        }
    }

    boolean isUemActive() {
        return this.mUemActive.get();
    }

    private void doSenderTask(boolean isNetworkAvailable) {
        if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("EventSender active ... mForceSendEvent=%b mForceUemUpdate=%b", this.mForceSendEvent.get(), this.mForceUemUpdate.get()));
        }
        ServerConfiguration config = AdkSettings.getInstance().getServerConfiguration();
        if (!isNetworkAvailable) {
            this.dao.deleteOldEvents(this.timeLineProvider.now(), config.isCachingCrashes());
            return;
        }
        Session session = Session.currentSession();
        if (session.isConfigurationApplied() && this.mForceSendEvent.compareAndSet(true, false)) {
            SendState sendState = this.sendMonitoringData(config, session.visitorId);
            switch (sendState) {
                case FINISHED: {
                    this.handleFlagUemUpdate(config);
                    break;
                }
                case MORE_DATA_AVAILABLE: {
                    this.mForceSendEvent.set(true);
                    this.handleFlagUemUpdate(config);
                    break;
                }
                case DATA_NOT_SENT: {
                    this.mForceSendEvent.set(true);
                    break;
                }
                case NO_DATA: {
                    if (!this.mForceUemUpdate.get()) break;
                    this.forceUemStateUpdate(config, session);
                }
            }
        } else if (this.mForceUemUpdate.get()) {
            this.forceUemStateUpdate(config, session);
        } else if (!session.isConfigurationApplied() && this.mForceSendEvent.get()) {
            this.forceUemStateUpdate(config, session);
        }
    }

    private void handleFlagUemUpdate(ServerConfiguration config) {
        Session newSession = Session.currentSession();
        if (newSession.isConfigurationApplied()) {
            this.mForceUemUpdate.set(false);
        } else if (this.mForceUemUpdate.get()) {
            this.forceUemStateUpdate(config, newSession);
        }
    }

    boolean sendCrashData(CustomSegment oaSeg, int serverId, Session session) {
        ArrayList<String> events = new ArrayList<String>();
        events.add(oaSeg.createEventData().toString());
        String updatableData = new BasicSegment.UpdatableDataGenerator().generateUpdatableData(session.sessionStartTime, session.multiplicity);
        MonitoringDataPacket monitoringData = new MonitoringDataPacket(Core.getOcvbString(oaSeg.session) + updatableData, events);
        boolean isMainThread = Thread.currentThread() == Looper.getMainLooper().getThread();
        boolean isRootEvent = oaSeg.getParentTagId() == 0L;
        ServerConfiguration currentServerConfig = AdkSettings.getInstance().getServerConfiguration();
        if (isMainThread) {
            PostCrashReportThread t;
            block3: {
                t = new PostCrashReportThread(currentServerConfig, monitoringData, serverId, isRootEvent, session.visitorId, session.sessionId);
                t.start();
                try {
                    t.join(5000L);
                }
                catch (InterruptedException ie) {
                    if (!Global.DEBUG) break block3;
                    Utility.zlogE(TAG, "crash reporting thread problem", ie);
                }
            }
            return t.hasBeenSuccessfully();
        }
        return this.handleSendEvents(currentServerConfig, monitoringData, serverId, isRootEvent, session.visitorId, session.sessionId, false);
    }

    void startNewSession(Session currentSession) {
        this.mForceUemUpdate.set(currentSession.isActive());
    }

    private void updateMultiplicityForEvents(Session currentSession) {
        if (Global.DEBUG) {
            Utility.zlogD(TAG, "updateMultiplicityForEvents begin @" + currentSession.getRunningTime());
        }
        DatabaseWriteQueue.getInstance().flushQueue();
        this.dao.updateMultiplicity(currentSession);
        if (Global.DEBUG) {
            Utility.zlogD(TAG, "updateMultiplicityForEvents end @" + currentSession.getRunningTime());
        }
    }

    protected class WriteLock {
        private File lockFile;

        private WriteLock() {
        }

        public boolean available() {
            File lf;
            try {
                lf = new File(AdkSettings.getInstance().getContext().getCacheDir() + File.separator + "Write.lock");
            }
            catch (Exception e) {
                if (Global.DEBUG) {
                    Utility.zlogE(TAG, e.toString());
                }
                return false;
            }
            boolean writeLocked = lf.exists();
            if (writeLocked && CommunicationManager.this.timeLineProvider.now() - lf.lastModified() > 60000L) {
                lf.delete();
                writeLocked = false;
                if (Global.DEBUG) {
                    Utility.zlogD(TAG, "Force taking write lock");
                }
            }
            if (!writeLocked) {
                try {
                    boolean created = lf.createNewFile();
                    if (created) {
                        lf.deleteOnExit();
                        this.lockFile = lf;
                    } else {
                        writeLocked = true;
                    }
                }
                catch (IOException e) {
                    if (Global.DEBUG) {
                        Utility.zlogE(TAG, e.toString());
                    }
                    writeLocked = true;
                }
            }
            return !writeLocked;
        }

        void release() {
            if (this.lockFile != null) {
                this.lockFile.delete();
                this.lockFile = null;
            }
        }
    }

    private class PostCrashReportThread
    extends Thread {
        private final ServerConfiguration serverConfig;
        private final MonitoringDataPacket monitoringData;
        private final int serverId;
        private final boolean isRootEvent;
        private final long visitorId;
        private final long sessionId;
        private boolean successfully = false;

        private PostCrashReportThread(ServerConfiguration currentServerConfig, MonitoringDataPacket monitoringData, int serverId, boolean isRootEvent, long visitorId, long sessionId) {
            this.setName("POST CrashReport");
            this.serverConfig = currentServerConfig;
            this.monitoringData = monitoringData;
            this.serverId = serverId;
            this.isRootEvent = isRootEvent;
            this.visitorId = visitorId;
            this.sessionId = sessionId;
        }

        @Override
        public void run() {
            this.successfully = CommunicationManager.this.handleSendEvents(this.serverConfig, this.monitoringData, this.serverId, this.isRootEvent, this.visitorId, this.sessionId, false);
        }

        private boolean hasBeenSuccessfully() {
            return this.successfully;
        }
    }

    class DataSendTimerTask
    extends TimerTask {
        DataSendTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CommunicationManager.this.connAttemptMonitor == null) {
                if (Global.DEBUG) {
                    Utility.zlogD(TAG, "invalid DataSendTimerTask appeared");
                }
                CommunicationManager.this.stopTimerLoop();
                return;
            }
            if (!CommunicationManager.this.connAttemptMonitor.moreAttemptsAllowed() && !CommunicationManager.this.mUemActive.get()) {
                CommunicationManager.this.stopTimerLoop();
                Core.shutdown(99L);
                CommunicationManager.this.connAttemptMonitor = null;
                return;
            }
            long diff = CommunicationManager.this.timeLineProvider.now() - CommunicationManager.this.uemLastUpdate;
            if (CommunicationManager.this.connAttemptMonitor.reconnAttemptInProgress()) {
                CommunicationManager.this.mForceUemUpdate.set(CommunicationManager.this.connAttemptMonitor.isTimeToConnect());
                if (!CommunicationManager.this.mForceUemUpdate.get()) {
                    if (Global.DEBUG) {
                        Utility.zlogD(TAG, String.format("ReconnWait: mUemActive=%b lastCheck=%ds ago", CommunicationManager.this.mUemActive.get(), diff / 1000L));
                    }
                    return;
                }
            }
            if (diff >= 0x6DDD00L) {
                CommunicationManager.this.mForceUemUpdate.set(true);
            }
            if (!CommunicationManager.this.mForceUemUpdate.get()) {
                CommunicationManager.this.mForceUemUpdate.set(CommunicationManager.this.connAttemptMonitor.isTimeToConnect() && Session.currentSession().isActive());
            }
            if (Global.DEBUG) {
                Utility.zlogD(TAG, String.format("TaskTimer mForceUemUpdate=%b mUemActive=%b", CommunicationManager.this.mForceUemUpdate.get(), CommunicationManager.this.mUemActive.get()));
            }
            if (!CommunicationManager.this.mUemActive.get() && !CommunicationManager.this.mForceUemUpdate.get()) {
                return;
            }
            if (CommunicationManager.this.calloutTable.isItTimeToSend()) {
                CommunicationManager.this.mForceSendEvent.set(true);
            }
            if (CustomSegment.firstSendOccurred.get() == 1) {
                CommunicationManager.this.mForceSendEvent.set(true);
                CustomSegment.firstSendOccurred.set(2);
            }
            if (Global.DEBUG) {
                Utility.zlogD(TAG, String.format("TaskTimer mForceSendEvent=%s thread ID=%d", CommunicationManager.this.mForceSendEvent.get(), CommunicationManager.this.mtEventSender.getId()));
            }
            if (CommunicationManager.this.mForceSendEvent.get() || CommunicationManager.this.mForceUemUpdate.get()) {
                Thread thread = CommunicationManager.this.mtEventSender;
                synchronized (thread) {
                    CommunicationManager.this.mtEventSender.notify();
                }
                CommunicationManager.this.uemLastUpdate = CommunicationManager.this.timeLineProvider.now();
            }
        }
    }

    private class EventSenderThread
    extends Thread {
        private EventSenderThread() {
            super(Global.LOG_PREFIX + "EventSenderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                CommunicationManager.this.mEventSenderActive = true;
                try {
                    boolean senderActive;
                    do {
                        EventSenderThread eventSenderThread = this;
                        synchronized (eventSenderThread) {
                            if (!CommunicationManager.this.mEventSenderActive) {
                                break;
                            }
                            this.wait();
                            senderActive = CommunicationManager.this.mEventSenderActive;
                        }
                        CommunicationManager.this.doSenderTask(AndroidMetrics.getInstance().isNetworkAvailable());
                    } while (senderActive);
                }
                catch (InterruptedException senderActive) {
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block8;
                    Utility.zlogD(TAG, e.getMessage(), e);
                }
            }
        }
    }

    static enum SendState {
        NO_DATA,
        DATA_NOT_SENT,
        MORE_DATA_AVAILABLE,
        FINISHED;

    }
}

