/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.Version;
import com.dynatrace.android.agent.comm.MonitoringDataPacket;
import com.dynatrace.android.agent.conf.InstrumentationFlavor;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.UserPrivacyOptions;
import com.dynatrace.android.agent.crash.CrashCatcher;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.data.VisitStoreVersion;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.agent.metrics.ConnectionType;
import com.dynatrace.android.agent.util.Utility;
import java.util.Locale;

public class BasicSegment {
    private static final String TAG = Global.LOG_PREFIX + "BasicSegment";
    private static final String DEV_ORIENT_P = "p";
    private static final String DEV_ORIENT_L = "l";
    private static final String DEV_GENUINE = "g";
    private static final String DEV_ROOTED = "r";
    private static final String CRASH_REP_LEVEL_OFF = "0";
    private static final String CRASH_REP_LEVEL_DISCONFIRMED = "1";
    private static final String CRASH_REP_LEVEL_CONFIRMED = "2";
    private static final int MAX_VERSION_NAME_LENGTH = 50;
    private static final long OCUPDT_STALE = 5000L;
    protected String mobuApplVersionName;
    protected int mobpApplVersionCode;
    protected AndroidMetrics metrics = AndroidMetrics.getInstance();
    protected String mockDeviceLocation = "";
    protected Long mtsOcUpdt = 0L;
    private final boolean isSessionReplayEnabled;
    private final InstrumentationFlavor instrumentationFlavor;

    protected BasicSegment(boolean isSessionReplayEnabled, InstrumentationFlavor instrumentationFlavor) {
        this.isSessionReplayEnabled = isSessionReplayEnabled;
        this.instrumentationFlavor = instrumentationFlavor;
        this.updateVersion();
    }

    public static boolean addNewVisitorInfoToDataChunk(MonitoringDataPacket data) {
        for (String eventData : data.events) {
            if (!eventData.contains("&pa=0")) continue;
            data.basicData = data.basicData + "&nu=" + CRASH_REP_LEVEL_DISCONFIRMED;
            return true;
        }
        return false;
    }

    private void updateVersion() {
        this.mobpApplVersionCode = 0;
        try {
            Context mcCtx = AdkSettings.getInstance().getContext();
            PackageInfo pI = mcCtx.getPackageManager().getPackageInfo(mcCtx.getPackageName(), 0);
            if (pI == null) {
                this.mobuApplVersionName = null;
            } else {
                this.mobuApplVersionName = Utility.trimString(pI.versionName, 50);
                this.mobpApplVersionCode = pI.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            this.mobuApplVersionName = null;
        }
    }

    public void update(boolean updateAllValues) {
        Long tsDelta;
        if (updateAllValues) {
            this.metrics.updateBasicMetrics();
        }
        if ((tsDelta = Long.valueOf(TimeLineProvider.getSystemTime() - this.mtsOcUpdt)) <= 5000L) {
            return;
        }
        this.mtsOcUpdt = TimeLineProvider.getSystemTime();
        this.metrics.updateCommonMetrics();
    }

    public StringBuilder createEventData(Session session, boolean replayCapture) {
        StringBuilder sb = new StringBuilder();
        sb.append("vv=").append("3");
        sb.append("&va=").append(Version.getFullVersion());
        sb.append("&ap=").append(AdkSettings.appIdEncoded);
        sb.append("&an=").append(Utility.urlEncode(AdkSettings.applName));
        sb.append("&ai=").append(Utility.urlEncode(AdkSettings.applIdentifier));
        if (this.mobuApplVersionName != null) {
            sb.append("&vn=").append(Utility.urlEncode(this.mobuApplVersionName));
        }
        sb.append("&vb=").append(this.mobpApplVersionCode);
        sb.append("&vi=").append(session.visitorId);
        sb.append("&sn=").append(session.sessionId);
        if (session.visitStoreVersion == VisitStoreVersion.V2_AGENT_SPLITTING) {
            sb.append("&ss=").append(session.sequenceNumber);
        }
        sb.append("&rm=").append(this.metrics.deviceMemorySize);
        sb.append("&cp=").append(Utility.urlEncode(this.metrics.cpuInformation));
        sb.append("&os=").append(Utility.urlEncode(this.metrics.operatingSystem));
        sb.append("&mf=").append(Utility.urlEncode(this.metrics.manufacturer));
        sb.append("&md=").append(Utility.urlEncode(this.metrics.modelId));
        sb.append("&rj=").append(this.metrics.deviceRooted ? DEV_ROOTED : DEV_GENUINE);
        sb.append("&ul=").append(this.metrics.userLang);
        sb.append("&sw=").append(this.metrics.screenWidth);
        sb.append("&sh=").append(this.metrics.screenHeight);
        sb.append("&sd=").append(this.metrics.screenDensityDpi);
        sb.append("&pt=").append(CRASH_REP_LEVEL_OFF);
        String orientation = null;
        if (this.metrics.deviceOrientation == 2) {
            orientation = DEV_ORIENT_L;
        } else if (this.metrics.deviceOrientation == 1) {
            orientation = DEV_ORIENT_P;
        }
        if (orientation != null) {
            sb.append("&so=").append(orientation);
        }
        if (this.metrics.batteryLevel >= 0) {
            sb.append("&bl=").append(this.metrics.batteryLevel);
        }
        if (this.metrics.deviceMemoryFree != null) {
            sb.append("&fm=").append(this.metrics.deviceMemoryFree);
        }
        if (this.metrics.deviceCarrier != null) {
            sb.append("&cr=").append(Utility.urlEncode(this.metrics.deviceCarrier));
        }
        if (this.metrics.connectionType != ConnectionType.OTHER) {
            sb.append("&ct=").append(this.metrics.connectionType.getProtocolValue());
            if (this.metrics.networkProtocol != null && this.metrics.networkProtocol.length() > 0) {
                sb.append("&np=").append(Utility.urlEncode(this.metrics.networkProtocol));
            }
        }
        PrivacyRules privacyRules = session.getPrivacyRules();
        if (this.mockDeviceLocation != null && this.mockDeviceLocation.length() > 0 && privacyRules.allowLocationReporting()) {
            sb.append("&lx=").append(Utility.urlEncode(this.mockDeviceLocation));
        }
        sb.append("&tt=").append("maandroid");
        sb.append("&dl=").append(privacyRules.getPrivacySettings().getDataCollectionLevel().ordinal());
        sb.append("&cl=").append(this.determineCrashReportingLevel(privacyRules.getPrivacySettings()));
        sb.append("&vs=").append(session.visitStoreVersion.getInternalValue());
        if (this.isSessionReplayEnabled) {
            sb.append("&sr=").append(this.determineSessionReplayValue(replayCapture, privacyRules.getPrivacySettings()));
        }
        sb.append("&fv=").append(this.instrumentationFlavor.getProtocolValue());
        return sb;
    }

    private String determineCrashReportingLevel(UserPrivacyOptions privacySettings) {
        if (!CrashCatcher.registered) {
            return CRASH_REP_LEVEL_OFF;
        }
        return privacySettings.isCrashReportingOptedIn() ? CRASH_REP_LEVEL_CONFIRMED : CRASH_REP_LEVEL_DISCONFIRMED;
    }

    private String determineSessionReplayValue(boolean replayCapture, UserPrivacyOptions privacySettings) {
        StringBuilder sb = new StringBuilder();
        sb.append(replayCapture ? CRASH_REP_LEVEL_DISCONFIRMED : CRASH_REP_LEVEL_OFF);
        if (privacySettings.isCrashReplayOptedIn()) {
            sb.append("c");
        }
        return sb.toString();
    }

    public void setGpsLocation(Location location) {
        this.mockDeviceLocation = location != null ? String.format(Locale.US, "%3.3fx%3.3f", location.getLatitude(), location.getLongitude()) : "";
        if (Global.DEBUG) {
            Utility.zlogD(TAG, "GPS/Network getLastKnownLocation mockDeviceLocation:" + this.mockDeviceLocation);
        }
    }

    public static class UpdatableDataGenerator {
        public String generateUpdatableData(long sessionStartFromClusterTimeLine, int multiplicity) {
            StringBuilder sb = new StringBuilder();
            sb.append("&tv=").append(sessionStartFromClusterTimeLine);
            sb.append("&tx=").append("__tsNow__");
            sb.append("&mp=");
            sb.append(multiplicity < 0 ? 1 : multiplicity);
            return sb.toString();
        }
    }
}

