/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.callback;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.lifecycle.LifecycleController;
import com.dynatrace.android.lifecycle.event.ActivityEventType;

public class DynatraceActivityLifecycleListener
implements Application.ActivityLifecycleCallbacks {
    private final LifecycleController lifecycleController;

    public DynatraceActivityLifecycleListener(LifecycleController lifecycleController) {
        this.lifecycleController = lifecycleController;
    }

    public void onActivityPreCreated(Activity activity, Bundle savedInstanceState) {
        this.lifecycleController.createEvent(activity.getLocalClassName(), ActivityEventType.ON_CREATE, TimeLineProvider.getSystemTime());
    }

    public void onActivityPostCreated(Activity activity, Bundle savedInstanceState) {
        this.lifecycleController.extendDuration(activity.getLocalClassName(), TimeLineProvider.getSystemTime());
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityPreStarted(Activity activity) {
        this.lifecycleController.createEvent(activity.getLocalClassName(), ActivityEventType.ON_START, TimeLineProvider.getSystemTime());
    }

    public void onActivityPostStarted(Activity activity) {
        this.lifecycleController.extendDuration(activity.getLocalClassName(), TimeLineProvider.getSystemTime());
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityPreResumed(Activity activity) {
        this.lifecycleController.createEvent(activity.getLocalClassName(), ActivityEventType.ON_RESUME, TimeLineProvider.getSystemTime());
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPostResumed(Activity activity) {
        this.lifecycleController.extendDuration(activity.getLocalClassName(), TimeLineProvider.getSystemTime());
        this.lifecycleController.closeAction(activity.getLocalClassName());
    }

    public void onActivityPaused(Activity activity) {
        this.lifecycleController.closeAction(activity.getLocalClassName());
    }

    public void onActivityStopped(Activity activity) {
        this.lifecycleController.closeAction(activity.getLocalClassName());
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.lifecycleController.closeAction(activity.getLocalClassName());
    }
}

