/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle;

import com.dynatrace.android.lifecycle.ActionAggregator;
import com.dynatrace.android.lifecycle.action.LifecycleAction;
import com.dynatrace.android.lifecycle.action.LifecycleActionFactory;
import com.dynatrace.android.lifecycle.action.LifecycleActionObserver;
import com.dynatrace.android.lifecycle.event.ActivityEventType;
import com.dynatrace.android.lifecycle.event.LifecycleEvent;
import com.dynatrace.android.lifecycle.provider.SequenceNumberProvider;
import java.util.HashMap;
import java.util.Map;

public class LifecycleController {
    private final Map<String, LifecycleAction> actionMap;
    private final LifecycleActionFactory actionFactory;
    private final LifecycleActionObserver actionObserver;
    private final SequenceNumberProvider sequenceNumberProvider;
    private final ActionAggregator actionAggregator;

    public LifecycleController(LifecycleActionFactory actionFactory, LifecycleActionObserver actionObserver, ActionAggregator actionAggregator, SequenceNumberProvider sequenceNumberProvider) {
        this.actionFactory = actionFactory;
        this.actionObserver = actionObserver;
        this.actionAggregator = actionAggregator;
        this.sequenceNumberProvider = sequenceNumberProvider;
        this.actionMap = new HashMap<String, LifecycleAction>();
    }

    public void createEvent(String lifecycleOwner, ActivityEventType eventType, long eventOccurrenceTime) {
        LifecycleAction lcAction = this.actionMap.get(lifecycleOwner);
        if (lcAction == null) {
            lcAction = this.actionFactory.createAction(lifecycleOwner, eventOccurrenceTime);
            this.actionMap.put(lifecycleOwner, lcAction);
            this.actionAggregator.aggregateLifecycleAction(lcAction);
        }
        int sequenceNr = this.sequenceNumberProvider.generateSequenceNumber();
        LifecycleEvent lcEvent = new LifecycleEvent(eventType, eventOccurrenceTime, sequenceNr);
        lcAction.addEvent(lcEvent);
    }

    public void extendDuration(String lifecycleOwner, long timeStamp) {
        LifecycleAction lcAction = this.actionMap.get(lifecycleOwner);
        if (lcAction == null) {
            return;
        }
        lcAction.setEndTime(timeStamp);
    }

    public void closeAction(String lifecycleOwner) {
        LifecycleAction lifecycleAction = this.actionMap.get(lifecycleOwner);
        if (lifecycleAction == null) {
            return;
        }
        this.actionObserver.closeAction(lifecycleAction);
        this.actionMap.remove(lifecycleOwner);
    }
}

