/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.LcState;
import com.dynatrace.android.agent.intf.AppStateListener;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.app.LcContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public final class LcUtility {
    private static final String LOGTAG = Global.LOG_PREFIX + "LcUtility";
    private static final LcUtility theInstance = new LcUtility();
    private static final Hashtable<String, LcState> activityState = new Hashtable();
    private String currActivityName;
    private String prevActivityName;
    private ArrayList<AppStateListener> appStatelisteners = new ArrayList(2);
    private boolean applInBg = false;
    private boolean tryGetTask = true;

    private LcUtility() {
    }

    public static LcUtility getInstance() {
        return theInstance;
    }

    public String getCurrentActivityName() {
        return this.applInBg ? null : this.currActivityName;
    }

    public String getPreviousActivityName() {
        return this.applInBg ? null : this.prevActivityName;
    }

    public void registerAppStateListener(AppStateListener listener) {
        if (this.appStatelisteners != null) {
            this.appStatelisteners.add(listener);
        }
    }

    void setActivityStateChange(Activity activity, LcState state) {
        if (activity == null || state == null) {
            return;
        }
        String id = LcContext.getInstance().getId(activity);
        activityState.put(id, state);
        String debugFormat = "%s %s (curr=%s prev=%s)";
        String activityName = activity.getClass().getSimpleName();
        switch (state) {
            case onActivityCreate: {
                if (!Global.DEBUG) break;
                Utility.zlogD(LOGTAG, String.format("%s %s (curr=%s prev=%s)", new Object[]{activityName, state, this.currActivityName, this.prevActivityName}));
                break;
            }
            case onActivityStart: 
            case onActivityResume: {
                if (!activityName.equals(this.currActivityName)) {
                    this.prevActivityName = this.currActivityName;
                    this.currActivityName = activityName;
                }
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, String.format("%s %s (curr=%s prev=%s)", new Object[]{activityName, state, this.currActivityName, this.prevActivityName}));
                }
                if (!this.applInBg) break;
                for (AppStateListener listener : this.appStatelisteners) {
                    listener.onAppGoesFg();
                }
                this.applInBg = false;
                break;
            }
            case onActivityPause: {
                if (!Global.DEBUG) break;
                Utility.zlogD(LOGTAG, String.format("%s %s (curr=%s prev=%s)", new Object[]{activityName, state, this.currActivityName, this.prevActivityName}));
                break;
            }
            case onActivityStop: {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, String.format("%s %s (curr=%s prev=%s)", new Object[]{activityName, state, this.currActivityName, this.prevActivityName}));
                }
                this.applInBg = this.isAppGoingBg(activity.getApplicationContext(), activity.isFinishing(), activity.isTaskRoot());
                if (this.applInBg) {
                    for (AppStateListener listener : this.appStatelisteners) {
                        listener.onAppGoesBg();
                    }
                }
                activityState.remove(id);
                break;
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean isAppGoingBg(Context context, boolean actIsFinishing, boolean actIsRoot) {
        ActivityManager activityMgr;
        boolean bg = false;
        List rtiList = null;
        if (this.tryGetTask && (activityMgr = (ActivityManager)context.getSystemService("activity")) != null) {
            try {
                rtiList = activityMgr.getRunningTasks(1);
            }
            catch (Exception e) {
                this.tryGetTask = false;
            }
        }
        if (rtiList == null || rtiList.isEmpty()) {
            bg = this.isAppGoingBg(actIsFinishing, actIsRoot);
        } else {
            ComponentName rootActivity = ((ActivityManager.RunningTaskInfo)rtiList.get((int)0)).topActivity;
            if (rootActivity.getPackageName().equals(context.getPackageName())) {
                boolean bl = bg = !actIsFinishing;
                if (bg) {
                    Enumeration<LcState> states = activityState.elements();
                    while (states.hasMoreElements()) {
                        LcState state = states.nextElement();
                        if (state.equals((Object)LcState.onActivityResume)) continue;
                        bg = false;
                        break;
                    }
                }
            } else {
                bg = true;
            }
        }
        this.applInBg = bg;
        return bg;
    }

    private boolean isAppGoingBg(boolean actIsFinishing, boolean actIsRoot) {
        boolean rootTaskEnding;
        boolean bg = true;
        boolean bl = rootTaskEnding = actIsFinishing && actIsRoot;
        if (rootTaskEnding && activityState.size() <= 1) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "App is exiting");
            }
            return true;
        }
        Enumeration<LcState> states = activityState.elements();
        while (states.hasMoreElements()) {
            LcState state = states.nextElement();
            if (state.equals((Object)LcState.onActivityStop)) continue;
            bg = false;
            break;
        }
        return bg;
    }
}

