/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.app;

import android.app.Activity;
import android.content.Context;
import com.dynatrace.android.agent.ActionThreadLocal;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.AppFgBgStateListener;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.LcAction;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ConfigurationFactory;
import com.dynatrace.android.agent.conf.DynatraceConfigurationBuilder;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.data.LcState;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.intf.AppStateListener;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.app.LcCallbacks;
import com.dynatrace.android.app.LcUtility;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class LcContext {
    private static final String LOGTAG = Global.LOG_PREFIX + "LcContext";
    private static final String APPSTART_ACTION = "AppStartAction";
    private static volatile LcContext theInstance = null;
    private static Vector<LcAction> actionVector;
    private static HashMap<String, LcAction> actionMap;
    private static AtomicLong sessionIdentifier;
    private LcCallbacks lifecycleCB = null;
    private AtomicBoolean captureMode = new AtomicBoolean(true);
    private AtomicBoolean isForceClosing = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LcContext(Context appContext, boolean needLifecycleCB) {
        this.init(appContext, needLifecycleCB);
        Class<LcContext> clazz = LcContext.class;
        synchronized (LcContext.class) {
            theInstance = this;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void initManualLifecycleInstrumentation(Context context) {
        Configuration config = ConfigurationFactory.getConfiguration();
        if (config == null) {
            new LcContext(context, true);
            LcContext.getInstance().getActivityLcCallbacks().onApplicationCreate();
        }
    }

    private LcContext() {
        this.init(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LcContext getInstance() {
        if (theInstance != null) return theInstance;
        Class<LcContext> clazz = LcContext.class;
        synchronized (LcContext.class) {
            if (theInstance != null) return theInstance;
            theInstance = new LcContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    private void init(Context appContext, boolean needLifecycleCB) {
        sessionIdentifier = new AtomicLong(0L);
        actionMap = new HashMap();
        actionVector = new Vector();
        if (needLifecycleCB) {
            AdkSettings adk = AdkSettings.getInstance();
            if (adk.getContext() == null) {
                Configuration tentativeConfig = new DynatraceConfigurationBuilder("appId", "https://www.dynatrace.com/d").buildConfiguration();
                adk.setup(tentativeConfig, appContext);
                ServerConfiguration config = adk.preferencesManager.getServerConfiguration(1);
                adk.switchServerConfiguration(config);
                adk.serverId = config.getServerId();
            }
            this.lifecycleCB = new LcCallbacks();
            Session.startNewSessionIfNeeded(PrivacyRules.PRIVACY_MODE_DEACTIVATED);
            LcUtility.getInstance().registerAppStateListener(new AppStateTracker());
            LcUtility.getInstance().registerAppStateListener(new AppFgBgStateListener());
        } else if (Global.DEBUG) {
            Utility.zlogW(LOGTAG, "Lifecycle data collection is NOT in effect");
        }
    }

    public boolean isLifecycleInEffect() {
        return this.lifecycleCB != null;
    }

    public boolean getCaptureMode() {
        return this.captureMode.get();
    }

    public void setCaptureMode(boolean mode) {
        this.captureMode.set(mode);
    }

    public LcCallbacks getActivityLcCallbacks() {
        return this.lifecycleCB;
    }

    public synchronized void resetLifecycleData() {
        this.forceCloseActiveActions("resetLifecycle");
        Utility.resetEventSeqNum();
        sessionIdentifier.incrementAndGet();
    }

    public LcAction getCurrentAction() {
        if (actionVector == null || actionVector.isEmpty()) {
            return null;
        }
        return actionVector.lastElement();
    }

    void enterAppStartAction() {
        if (!this.getCaptureMode()) {
            return;
        }
        DTXAutoAction gaua = this.getAutoUserAction("Loading " + AdkSettings.applName, 0L);
        LcAction action = LcAction.createAction(AdkSettings.applName, EventType.APP_START, gaua);
        actionMap.put(APPSTART_ACTION, action);
        actionVector.add(action);
        gaua.startTimer(5000);
    }

    void leaveAppStartAction(Activity activity) {
        LcAction lcAction = actionMap.remove(APPSTART_ACTION);
        if (lcAction != null) {
            lcAction.setActivityName(activity.getClass().getSimpleName());
            this.leaveLcAction(lcAction);
        }
    }

    public void cleanUpAppStart(LcAction lcActionParam) {
        LcAction lcAction = actionMap.remove(APPSTART_ACTION);
        if (lcAction != null && lcAction != lcActionParam && Global.DEBUG) {
            Utility.zlogE(LOGTAG, "wrong lcAction in cleanUpAppStart");
        }
        actionVector.remove(lcActionParam);
    }

    public void cleanUpDisplay(LcAction lcActionParam) {
        actionVector.remove(lcActionParam);
    }

    void enterAction(Activity activity, LcState state) {
        if (activity == null || !this.getCaptureMode()) {
            return;
        }
        String id = this.getId(activity);
        LcAction action = actionMap.get(id);
        if (action == null) {
            EventType eventType;
            switch (state) {
                case onActivityCreate: {
                    eventType = EventType.DISPLAY;
                    break;
                }
                case onActivityRestart: 
                case onActivityResume: 
                case onActivityStart: {
                    eventType = EventType.REDISPLAY;
                    break;
                }
                default: {
                    return;
                }
            }
            String activityName = activity.getClass().getSimpleName();
            DTXAutoAction gaua = DTXAutoAction.getAutoAction();
            if (gaua == null) {
                Session session = Session.determineActiveSession(true, true);
                int serverId = AdkSettings.getInstance().serverId;
                gaua = DTXAutoAction.createAutoAction("Loading " + activityName, session, serverId);
            }
            gaua.cancelTimer();
            action = LcAction.createAction(activityName, eventType, gaua);
            action.setActivityName(activityName);
            actionMap.put(id, action);
            actionVector.add(action);
        }
    }

    void leaveAction(Activity activity, LcState state) {
        if (activity == null) {
            return;
        }
        this.leaveLcAction(actionMap.remove(this.getId(activity)));
    }

    private void leaveLcAction(LcAction action) {
        if (action != null) {
            action.leaveAction();
            this.startAutoUserActionTimer(action);
            actionVector.remove(action);
        }
    }

    void addEvent(Activity activity, LcState state) {
        if (activity == null || !this.getCaptureMode()) {
            return;
        }
        String id = this.getId(activity);
        LcAction action = actionMap.get(id);
        if (action == null) {
            action = this.getCurrentAction();
        }
        if (action != null) {
            action.addChildEvent(state.toString());
        }
    }

    String getId(Activity activity) {
        return activity.getClass().getSimpleName() + activity.hashCode() + sessionIdentifier.get();
    }

    private DTXAutoAction getAutoUserAction(String name, long startTime) {
        DTXAutoAction gaua = DTXAutoAction.getAutoAction();
        if (gaua == null) {
            Session session = Session.determineActiveSession(false, true);
            int serverId = AdkSettings.getInstance().serverId;
            gaua = DTXAutoAction.createAutoAction(name, session, serverId, startTime);
        }
        return gaua;
    }

    private void startAutoUserActionTimer(LcAction action) {
        if (action == null) {
            return;
        }
        DTXActionImpl parentAction = action.getParentAction();
        if (parentAction != null) {
            ((DTXAutoAction)parentAction).startTimerIfNeeded();
        }
    }

    public void forceCloseActiveActions(String reason) {
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("%s ... force closed actions due to %s", Thread.currentThread().getName(), reason));
        }
        ActionThreadLocal.closeAll();
        DTXAutoAction.closeAll();
    }

    public boolean isForceClosingActions() {
        return this.isForceClosing.get();
    }

    static {
        sessionIdentifier = null;
    }

    private static class AppStateTracker
    implements AppStateListener {
        private AppStateTracker() {
        }

        @Override
        public void onAppGoesFg() {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, AdkSettings.applName + " returns to fg");
            }
            LcContext.getInstance().isForceClosing.set(false);
        }

        @Override
        public void onAppGoesBg() {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, AdkSettings.applName + " goes into bg");
            }
            LcContext.getInstance().isForceClosing.set(true);
            LcContext.getInstance().forceCloseActiveActions("GoingBg");
        }
    }
}

