/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.app;

import android.app.Activity;
import android.os.Bundle;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.data.LcState;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.app.LcContext;
import com.dynatrace.android.app.LcUtility;

public class LcCallbacks {
    private static final String LOGTAG = Global.LOG_PREFIX + "LcCallbacks";
    private boolean trackApplStartTime = false;

    LcCallbacks() {
    }

    public void onApplicationCreate() {
        if (Global.DEBUG) {
            Utility.zlogI(LOGTAG, String.format("%s startup begins", AdkSettings.applName));
        }
        LcContext.getInstance().enterAppStartAction();
        this.trackApplStartTime = true;
    }

    public void onActivityCreate(Activity activity) {
        this.onActivityCreate(activity, null);
    }

    public void onActivityCreate(Activity activity, Bundle savedInstanceState) {
        this.logMsg(activity, LcState.onActivityCreate);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().enterAction(activity, LcState.onActivityCreate);
        LcContext.getInstance().addEvent(activity, LcState.onActivityCreate);
        LcUtility.getInstance().setActivityStateChange(activity, LcState.onActivityCreate);
    }

    public void onActivityPostCreate(Activity activity) {
        this.onActivityPostCreate(activity, null);
    }

    public void onActivityPostCreate(Activity activity, Bundle savedInstanceState) {
        this.logMsg(activity, LcState.onActivityPostCreate);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().addEvent(activity, LcState.onActivityPostCreate);
    }

    public void onActivityRestart(Activity activity) {
        this.logMsg(activity, LcState.onActivityRestart);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().addEvent(activity, LcState.onActivityRestart);
    }

    public void onActivityStart(Activity activity) {
        this.logMsg(activity, LcState.onActivityStart);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().enterAction(activity, LcState.onActivityStart);
        LcContext.getInstance().addEvent(activity, LcState.onActivityStart);
        LcUtility.getInstance().setActivityStateChange(activity, LcState.onActivityStart);
    }

    public void onActivityResume(Activity activity) {
        this.logMsg(activity, LcState.onActivityResume);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().enterAction(activity, LcState.onActivityResume);
        LcContext.getInstance().addEvent(activity, LcState.onActivityResume);
        LcUtility.getInstance().setActivityStateChange(activity, LcState.onActivityResume);
    }

    public void onActivityPostResume(Activity activity) {
        this.logMsg(activity, LcState.onActivityPostResume);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (this.trackApplStartTime) {
            DTXAutoAction gaua;
            if (Global.DEBUG) {
                Utility.zlogI(LOGTAG, String.format("%s startup ends", AdkSettings.applName));
            }
            if (conf != null && !conf.activityMonitoring && (gaua = DTXAutoAction.getAutoAction()) != null) {
                gaua.cancelTimer();
            }
            LcContext.getInstance().leaveAppStartAction(activity);
            this.trackApplStartTime = false;
        }
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().addEvent(activity, LcState.onActivityPostResume);
        LcContext.getInstance().leaveAction(activity, LcState.onActivityPostResume);
    }

    public void onActivityPause(Activity activity) {
        this.logMsg(activity, LcState.onActivityPause);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().leaveAction(activity, LcState.onActivityPause);
        LcUtility.getInstance().setActivityStateChange(activity, LcState.onActivityPause);
    }

    public void onActivityStop(Activity activity) {
        this.logMsg(activity, LcState.onActivityStop);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().leaveAction(activity, LcState.onActivityStop);
        LcUtility.getInstance().setActivityStateChange(activity, LcState.onActivityStop);
    }

    public void onActivityDestroy(Activity activity) {
        this.logMsg(activity, LcState.onActivityDestroy);
        Configuration conf = AdkSettings.getInstance().getConfiguration();
        if (conf != null && !conf.activityMonitoring) {
            return;
        }
        LcContext.getInstance().leaveAction(activity, LcState.onActivityDestroy);
    }

    private void logMsg(Activity activity, LcState state) {
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("%s ... %s", activity.getClass().getSimpleName(), state.toString()));
        }
    }
}

