/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.data;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.AgentStateListener;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.SessionSplitConfiguration;
import com.dynatrace.android.agent.data.RandomFactory;
import com.dynatrace.android.agent.data.SessionState;
import com.dynatrace.android.agent.data.VisitStoreVersion;
import com.dynatrace.android.agent.util.Utility;
import java.util.Random;

public class Session {
    static final int TC_MAX_VALUE = 100;
    private static final int SELF_MONITORING_SESSION_LIMIT = 20;
    private static final String TAG = Global.LOG_PREFIX + "Session";
    static RandomFactory randomFactory = new RandomFactory();
    private static volatile Session currentSession = null;
    public final long sessionStartTime;
    public long visitorId;
    public long sessionId;
    public int sequenceNumber = 0;
    public final VisitStoreVersion visitStoreVersion;
    public int multiplicity = -1;
    private SessionState state = SessionState.CREATED;
    private volatile int selfMonitoringCount;
    private Random random;
    private volatile int rootActionCount = 0;
    private volatile long lastInteractionTime;
    private PrivacyRules privacyRules;

    public Session(long sessionStartTime, Random random, VisitStoreVersion visitStoreVersion, PrivacyRules privacyRules) {
        this.sessionStartTime = sessionStartTime;
        this.lastInteractionTime = sessionStartTime;
        this.random = random;
        this.selfMonitoringCount = 0;
        this.visitStoreVersion = visitStoreVersion;
        if (visitStoreVersion == VisitStoreVersion.V1_SERVER_SPLITTING) {
            this.sequenceNumber = -1;
        }
        this.privacyRules = privacyRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Session startNewSessionIfNeeded(PrivacyRules privacyRules) {
        if (currentSession != null) return currentSession;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (currentSession != null) return currentSession;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Session.startNewSession(privacyRules);
        }
    }

    public static Session startNewSession(PrivacyRules privacyRules) {
        ServerConfiguration serverConfig = AdkSettings.getInstance().getServerConfiguration();
        currentSession = new Session(TimeLineProvider.getSystemTime(), randomFactory.generateRandom(), serverConfig.getVisitStoreVersion(), privacyRules);
        return currentSession;
    }

    public static Session currentSession() {
        if (currentSession != null) {
            return currentSession;
        }
        return Session.startNewSessionIfNeeded(PrivacyRules.PRIVACY_MODE_DEACTIVATED);
    }

    public static Session determineActiveSession(boolean mandatory, boolean increaseActionCount) {
        Session curSession = Session.currentSession();
        if (curSession.visitStoreVersion == VisitStoreVersion.V1_SERVER_SPLITTING) {
            return curSession;
        }
        if (!mandatory) {
            SessionSplitConfiguration sessionSplitConfiguration = AdkSettings.getInstance().getSessionSplitConfiguration();
            long timeStamp = TimeLineProvider.getSystemTime();
            if (curSession.lastInteractionTime + sessionSplitConfiguration.getInactivityTimeoutMs() < timeStamp || curSession.sessionStartTime + sessionSplitConfiguration.getMaxSessionDurationMs() < timeStamp) {
                Core.startNewSession(true, curSession.getPrivacyRules());
                curSession = currentSession;
            } else if (increaseActionCount && curSession.isActive() && curSession.rootActionCount >= sessionSplitConfiguration.getMaxRootActions()) {
                curSession = curSession.split();
                ++curSession.sequenceNumber;
                currentSession = curSession;
                Core.startNewSession(curSession, true);
            }
        }
        if (increaseActionCount) {
            ++curSession.rootActionCount;
        }
        curSession.lastInteractionTime = TimeLineProvider.getSystemTime();
        return curSession;
    }

    public static Session determineActiveSessionForInternalEvent() {
        return currentSession;
    }

    private Session split() {
        Session session = new Session(TimeLineProvider.getSystemTime(), randomFactory.generateRandom(), this.visitStoreVersion, this.privacyRules);
        session.visitorId = this.visitorId;
        session.sessionId = this.sessionId;
        session.sequenceNumber = this.sequenceNumber;
        session.multiplicity = this.multiplicity;
        session.state = this.state;
        if (Global.DEBUG) {
            Utility.zlogD(TAG, "Split session");
        }
        return session;
    }

    public long getRunningTime() {
        return TimeLineProvider.getSystemTime() - this.sessionStartTime;
    }

    public synchronized void updateLastInteractionTime(long time) {
        if (time > this.lastInteractionTime) {
            this.lastInteractionTime = time;
        }
    }

    public void handleTrafficLimitation(int trafficControl, int multiplicity, AgentStateListener agentStateListener) {
        if (this.state != SessionState.CREATED) {
            return;
        }
        boolean enableSession = multiplicity > 0;
        this.multiplicity = multiplicity;
        if (!enableSession && Global.DEBUG) {
            Utility.zlogD(TAG, "Session disabled by overload prevention (mp=0)");
        }
        if (enableSession && !(enableSession = this.rollDice(100, trafficControl)) && Global.DEBUG) {
            Utility.zlogD(TAG, "Session disabled by traffic control: tc=" + trafficControl);
        }
        SessionState sessionState = this.state = enableSession ? SessionState.ENABLED : SessionState.DISABLED;
        if (!enableSession && agentStateListener != null) {
            agentStateListener.onSessionDiscarded(this);
        }
    }

    private boolean rollDice(int poolSize, int positives) {
        return this.random.nextInt(poolSize) < positives;
    }

    public boolean isConfigurationApplied() {
        return this.state.isConfigurationApplied();
    }

    public boolean isActive() {
        return this.state.isActive();
    }

    public void addSelfMonitoringEvent() {
        ++this.selfMonitoringCount;
    }

    public boolean isSelfMonitoringLimitReached() {
        return this.selfMonitoringCount >= 20;
    }

    public PrivacyRules getPrivacyRules() {
        return this.privacyRules;
    }

    @Deprecated
    public void internalSetPrivacyRules(PrivacyRules privacyRules) {
        this.privacyRules = privacyRules;
    }
}

