/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.crash;

import com.dynatrace.android.agent.conf.InstrumentationMode;
import com.dynatrace.android.agent.crash.JavaStacktraceProcessor;
import com.dynatrace.android.agent.crash.SafeXamarinStacktraceProcessor;
import com.dynatrace.android.agent.crash.StacktraceProcessor;
import com.dynatrace.android.agent.crash.XamarinStacktraceProcessor;

public class StacktraceProcessorFactory {
    public static final int MAX_REASON_LENGTH = 1000;
    public static final int MAX_STACKTRACE_LENGTH = 128000;
    public static final int STACKTRACE_LINES = Integer.MAX_VALUE;
    @Deprecated
    public static final int ERROR_STACKTRACE_LINES = 10;

    public StacktraceProcessor determineCrashProcessor(Throwable throwable, InstrumentationMode instrMode) {
        String xamarinException;
        int maxLines = Integer.MAX_VALUE;
        if (instrMode == InstrumentationMode.XAMARIN && (xamarinException = XamarinStacktraceProcessor.convertToXamarinOrNull(throwable)) != null) {
            return new SafeXamarinStacktraceProcessor(throwable, xamarinException, Integer.MAX_VALUE);
        }
        return new JavaStacktraceProcessor(throwable, Integer.MAX_VALUE);
    }
}

