/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.cookie;

import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.data.VisitStoreVersion;

class CookieProducer {
    CookieProducer() {
    }

    String createAdkCookie(Session session, String encodedApplicationId) {
        String delimiter = "_";
        StringBuilder sb = new StringBuilder();
        sb.append(session.visitorId).append(delimiter);
        sb.append(session.sessionId);
        if (session.visitStoreVersion == VisitStoreVersion.V2_AGENT_SPLITTING) {
            sb.append("-").append(session.sequenceNumber);
        }
        sb.append(delimiter);
        sb.append(encodedApplicationId).append(delimiter);
        sb.append("m");
        return sb.toString();
    }

    String createAdkSettingsCookie(Session session) {
        String prefix = "v_4_ol_";
        if (!session.isConfigurationApplied()) {
            return prefix + "2";
        }
        if (!session.isActive()) {
            return prefix + "1";
        }
        return prefix + "0_mul_" + session.multiplicity;
    }

    String createDtCookie(long visitorId, long sessionId) {
        return visitorId + "_" + sessionId;
    }
}

