/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.DataCollectionLevel;
import com.dynatrace.android.agent.util.Utility;

public final class UserPrivacyOptions {
    private static final String LOGTAG = Global.LOG_PREFIX + "UserPrivacyOptions";
    private final DataCollectionLevel dataCollectionLevel;
    private final boolean crashReportingOptedIn;
    private final boolean crashReplayOptedIn;

    private UserPrivacyOptions(Builder builder) {
        this.dataCollectionLevel = builder.dataCollectionLevel;
        this.crashReportingOptedIn = builder.crashReportingOptedIn;
        this.crashReplayOptedIn = builder.crashReplayOptedIn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DataCollectionLevel getDataCollectionLevel() {
        return this.dataCollectionLevel;
    }

    public boolean isCrashReportingOptedIn() {
        return this.crashReportingOptedIn;
    }

    boolean isCrashReplayOptedIn() {
        return this.crashReplayOptedIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPrivacyOptions that = (UserPrivacyOptions)o;
        return this.dataCollectionLevel == that.dataCollectionLevel && this.crashReportingOptedIn == that.crashReportingOptedIn && this.crashReplayOptedIn == that.crashReplayOptedIn;
    }

    public int hashCode() {
        int result = this.dataCollectionLevel.hashCode();
        result = 31 * result + (this.crashReportingOptedIn ? 1 : 0);
        result = 31 * result + (this.crashReplayOptedIn ? 1 : 0);
        return result;
    }

    public String toString() {
        return "UserPrivacyOptions{dataCollectionLevel=" + (Object)((Object)this.dataCollectionLevel) + ", crashReportingOptedIn=" + this.crashReportingOptedIn + ", crashReplayOptedIn=" + this.crashReplayOptedIn + '}';
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private DataCollectionLevel dataCollectionLevel;
        private boolean crashReportingOptedIn;
        private boolean crashReplayOptedIn;

        public Builder() {
            this.dataCollectionLevel = DataCollectionLevel.OFF;
            this.crashReportingOptedIn = false;
            this.crashReplayOptedIn = false;
        }

        private Builder(UserPrivacyOptions userPrivacyOptions) {
            this.dataCollectionLevel = userPrivacyOptions.dataCollectionLevel;
            this.crashReportingOptedIn = userPrivacyOptions.crashReportingOptedIn;
            this.crashReplayOptedIn = userPrivacyOptions.crashReplayOptedIn;
        }

        public Builder withDataCollectionLevel(DataCollectionLevel dataCollectionLevel) {
            if (dataCollectionLevel == null) {
                if (Global.DEBUG) {
                    Utility.zlogE(LOGTAG, "dataCollectionLevel == null is not allowed");
                }
                return this;
            }
            this.dataCollectionLevel = dataCollectionLevel;
            return this;
        }

        public Builder withCrashReportingOptedIn(boolean crashReportingOptedIn) {
            this.crashReportingOptedIn = crashReportingOptedIn;
            return this;
        }

        Builder withCrashReplayOptedIn(boolean crashReplayOptedIn) {
            this.crashReplayOptedIn = crashReplayOptedIn;
            return this;
        }

        public UserPrivacyOptions build() {
            return new UserPrivacyOptions(this);
        }
    }
}

