/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.conf.ReplayConfiguration;
import com.dynatrace.android.agent.conf.SessionSplitConfiguration;
import com.dynatrace.android.agent.data.VisitStoreVersion;

public class ServerConfiguration {
    static final boolean DEFAULT_SELFMONITORING = true;
    static final int DEFAULT_SEND_INTERVAL_SEC = 120;
    static final VisitStoreVersion DEFAULT_VISIT_STORE_VERSION = VisitStoreVersion.V1_SERVER_SPLITTING;
    static final int DEFAULT_MAX_CACHED_CRASHES = 0;
    static final int DEFAULT_CAPTURE = 1;
    static final int DEFAULT_CAPTURE_LIFECYCLE = 1;
    static final int DEFAULT_REPORT_CRASHES = 1;
    static final int DEFAULT_REPORT_ERRORS = 1;
    static final int DEFAULT_TRAFFIC_CONTROL_PERCENTAGE = 100;
    static final int DEFAULT_MULTIPLICITY = 1;
    static final int DEFAULT_SERVERID = 1;
    static final boolean DEFAULT_SWITCH_SERVER = false;
    static final int DEFAULT_MAX_BEACON_SIZE_KB_SAAS = 150;
    static final int DEFAULT_MAX_BEACON_SIZE_KB_APPMON = 30;
    private static final Status DEFAULT_STATUS = Status.OK;
    private final int maxBeaconSizeKb;
    private final boolean selfmonitoring;
    private final SessionSplitConfiguration sessionSplitConfiguration;
    private final int sendIntervalSec;
    private final VisitStoreVersion visitStoreVersion;
    private final int maxCachedCrashesCount;
    private final int capture;
    private final int captureLifecycle;
    private final int reportCrashes;
    private final int reportErrors;
    private final int trafficControlPercentage;
    private final ReplayConfiguration replayConfiguration;
    private final int multiplicity;
    private final int serverId;
    private final boolean switchServer;
    private final Status status;
    private final long timestamp;

    private ServerConfiguration(Builder builder) {
        this.maxBeaconSizeKb = builder.maxBeaconSizeKb;
        this.selfmonitoring = builder.selfmonitoring;
        this.sessionSplitConfiguration = builder.sessionSplitConfiguration;
        this.sendIntervalSec = builder.sendIntervalSec;
        this.visitStoreVersion = builder.visitStoreVersion;
        this.maxCachedCrashesCount = builder.maxCachedCrashesCount;
        this.capture = builder.capture;
        this.captureLifecycle = builder.captureLifecycle;
        this.reportCrashes = builder.reportCrashes;
        this.reportErrors = builder.reportErrors;
        this.trafficControlPercentage = builder.trafficControlPercentage;
        this.replayConfiguration = builder.replayConfiguration;
        this.multiplicity = builder.multiplicity;
        this.serverId = builder.serverId;
        this.switchServer = builder.switchServer;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long maxSendLength() {
        return this.maxBeaconSizeKb * 1024 - 5;
    }

    public int getMaxBeaconSizeKb() {
        return this.maxBeaconSizeKb;
    }

    public boolean isSelfmonitoring() {
        return this.selfmonitoring;
    }

    public SessionSplitConfiguration getSessionSplitConfiguration() {
        return this.sessionSplitConfiguration;
    }

    public int getSendIntervalSec() {
        return this.sendIntervalSec;
    }

    public VisitStoreVersion getVisitStoreVersion() {
        return this.visitStoreVersion;
    }

    public int getMaxCachedCrashesCount() {
        return this.maxCachedCrashesCount;
    }

    public boolean isCachingCrashes() {
        return this.maxCachedCrashesCount > 0;
    }

    public int getCapture() {
        return this.capture;
    }

    public boolean isCaptureOn() {
        return this.capture == 1;
    }

    public int getCaptureLifecycle() {
        return this.captureLifecycle;
    }

    public int getReportCrashes() {
        return this.reportCrashes;
    }

    public int getReportErrors() {
        return this.reportErrors;
    }

    public int getTrafficControlPercentage() {
        return this.trafficControlPercentage;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public int getServerId() {
        return this.serverId;
    }

    public boolean isSwitchServer() {
        return this.switchServer;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Status getStatus() {
        return this.status;
    }

    public ReplayConfiguration getReplayConfiguration() {
        return this.replayConfiguration;
    }

    public Builder newBuilder(boolean useDefaultDynamicConfig) {
        return new Builder(this, useDefaultDynamicConfig);
    }

    public Builder newBuilder() {
        return this.newBuilder(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfiguration serverConfig = (ServerConfiguration)o;
        return this.maxBeaconSizeKb == serverConfig.maxBeaconSizeKb && this.selfmonitoring == serverConfig.selfmonitoring && this.sessionSplitConfiguration.equals(serverConfig.sessionSplitConfiguration) && this.sendIntervalSec == serverConfig.sendIntervalSec && this.visitStoreVersion == serverConfig.visitStoreVersion && this.maxCachedCrashesCount == serverConfig.maxCachedCrashesCount && this.capture == serverConfig.capture && this.captureLifecycle == serverConfig.captureLifecycle && this.reportCrashes == serverConfig.reportCrashes && this.reportErrors == serverConfig.reportErrors && this.trafficControlPercentage == serverConfig.trafficControlPercentage && this.replayConfiguration.equals(serverConfig.replayConfiguration) && this.multiplicity == serverConfig.multiplicity && this.serverId == serverConfig.serverId && this.switchServer == serverConfig.switchServer && this.timestamp == serverConfig.timestamp && this.status == serverConfig.status;
    }

    public int hashCode() {
        int result = this.maxBeaconSizeKb;
        result = 31 * result + (this.selfmonitoring ? 1 : 0);
        result = 31 * result + this.sessionSplitConfiguration.hashCode();
        result = 31 * result + this.sendIntervalSec;
        result = 31 * result + this.visitStoreVersion.ordinal();
        result = 31 * result + this.maxCachedCrashesCount;
        result = 31 * result + this.capture;
        result = 31 * result + this.captureLifecycle;
        result = 31 * result + this.reportCrashes;
        result = 31 * result + this.reportErrors;
        result = 31 * result + this.trafficControlPercentage;
        result = 31 * result + this.replayConfiguration.hashCode();
        result = 31 * result + this.multiplicity;
        result = 31 * result + this.serverId;
        result = 31 * result + (this.switchServer ? 1 : 0);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "ServerConfiguration{maxBeaconSizeKb=" + this.maxBeaconSizeKb + ", selfmonitoring=" + this.selfmonitoring + ", sessionSplitConfiguration=" + this.sessionSplitConfiguration + ", sendIntervalSec=" + this.sendIntervalSec + ", visitStoreVersion=" + (Object)((Object)this.visitStoreVersion) + ", maxCachedCrashesCount=" + this.maxCachedCrashesCount + ", capture=" + this.capture + ", captureLifecycle=" + this.captureLifecycle + ", reportCrashes=" + this.reportCrashes + ", reportErrors=" + this.reportErrors + ", trafficControlPercentage=" + this.trafficControlPercentage + ", replayConfiguration=" + this.replayConfiguration + ", multiplicity=" + this.multiplicity + ", serverId=" + this.serverId + ", switchServer=" + this.switchServer + ", status=" + (Object)((Object)this.status) + ", timestamp=" + this.timestamp + '}';
    }

    public static class Builder {
        private int maxBeaconSizeKb;
        private boolean selfmonitoring;
        private SessionSplitConfiguration sessionSplitConfiguration;
        private int sendIntervalSec;
        private VisitStoreVersion visitStoreVersion;
        private int maxCachedCrashesCount;
        private int capture;
        private int captureLifecycle;
        private int reportCrashes;
        private int reportErrors;
        private int trafficControlPercentage;
        private ReplayConfiguration replayConfiguration;
        private int multiplicity;
        private int serverId;
        private boolean switchServer;
        private Status status;
        private long timestamp;

        public Builder() {
            this.maxBeaconSizeKb = 150;
            this.selfmonitoring = true;
            this.sessionSplitConfiguration = SessionSplitConfiguration.DEFAULT_SESSION_SPLIT_CONFIGURATION;
            this.sendIntervalSec = 120;
            this.visitStoreVersion = DEFAULT_VISIT_STORE_VERSION;
            this.maxCachedCrashesCount = 0;
            this.capture = 1;
            this.captureLifecycle = 1;
            this.reportCrashes = 1;
            this.reportErrors = 1;
            this.trafficControlPercentage = 100;
            this.replayConfiguration = ReplayConfiguration.DEFAULT_REPLAY_CONFIGURATION;
            this.multiplicity = 1;
            this.serverId = 1;
            this.switchServer = false;
            this.status = DEFAULT_STATUS;
            this.timestamp = 0L;
        }

        public Builder(ServerConfiguration oldServerConfig, boolean useDefaultDynamicConfig) {
            this.maxBeaconSizeKb = oldServerConfig.maxBeaconSizeKb;
            this.selfmonitoring = oldServerConfig.selfmonitoring;
            this.sessionSplitConfiguration = oldServerConfig.sessionSplitConfiguration;
            this.sendIntervalSec = oldServerConfig.sendIntervalSec;
            this.visitStoreVersion = oldServerConfig.visitStoreVersion;
            this.maxCachedCrashesCount = oldServerConfig.maxCachedCrashesCount;
            this.capture = oldServerConfig.capture;
            this.captureLifecycle = oldServerConfig.captureLifecycle;
            this.reportCrashes = oldServerConfig.reportCrashes;
            this.reportErrors = oldServerConfig.reportErrors;
            this.trafficControlPercentage = oldServerConfig.trafficControlPercentage;
            this.replayConfiguration = oldServerConfig.replayConfiguration.newBuilder().build();
            this.timestamp = oldServerConfig.timestamp;
            if (useDefaultDynamicConfig) {
                this.multiplicity = 1;
                this.serverId = 1;
                this.switchServer = false;
                this.status = DEFAULT_STATUS;
            } else {
                this.multiplicity = oldServerConfig.multiplicity;
                this.serverId = oldServerConfig.serverId;
                this.switchServer = oldServerConfig.switchServer;
                this.status = oldServerConfig.status;
            }
        }

        public Builder(ServerConfiguration oldServerConfig) {
            this(oldServerConfig, false);
        }

        public ServerConfiguration build() {
            return new ServerConfiguration(this);
        }

        public Builder withMaxBeaconSizeKb(int maxBeaconSizeKb) {
            this.maxBeaconSizeKb = maxBeaconSizeKb;
            return this;
        }

        public Builder withSelfmonitoring(boolean selfmonitoring) {
            this.selfmonitoring = selfmonitoring;
            return this;
        }

        public Builder withSessionSplitConfiguration(SessionSplitConfiguration sessionSplitConfiguration) {
            this.sessionSplitConfiguration = sessionSplitConfiguration;
            return this;
        }

        public Builder withSendIntervalSec(int sendIntervalSec) {
            this.sendIntervalSec = sendIntervalSec;
            return this;
        }

        public Builder withVisitStoreVersion(VisitStoreVersion visitStoreVersion) {
            this.visitStoreVersion = visitStoreVersion;
            return this;
        }

        public Builder withMaxCachedCrashesCount(int maxCachedCrashesCount) {
            this.maxCachedCrashesCount = maxCachedCrashesCount;
            return this;
        }

        public Builder withCapture(int capture) {
            this.capture = capture;
            return this;
        }

        public Builder withCaptureOff() {
            this.capture = 0;
            return this;
        }

        public Builder withCaptureLifecycle(int captureLifecycle) {
            this.captureLifecycle = captureLifecycle;
            return this;
        }

        public Builder withReportCrashes(int reportCrashes) {
            this.reportCrashes = reportCrashes;
            return this;
        }

        public Builder withReportErrors(int reportErrors) {
            this.reportErrors = reportErrors;
            return this;
        }

        public Builder withTrafficControlPercentage(int trafficControlPercentage) {
            this.trafficControlPercentage = trafficControlPercentage;
            return this;
        }

        public Builder withMultiplicity(int multiplicity) {
            this.multiplicity = multiplicity;
            return this;
        }

        public Builder withServerId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withSwitchServer(boolean switchServer) {
            this.switchServer = switchServer;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withReplayConfiguration(ReplayConfiguration replayConfiguration) {
            this.replayConfiguration = replayConfiguration;
            return this;
        }
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

