/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

public final class ReplayConfiguration {
    static final ReplayConfiguration DEFAULT_REPLAY_CONFIGURATION = ReplayConfiguration.builder().build();
    private static final boolean DEFAULT_CAPTURE = false;
    private final boolean capture;

    private ReplayConfiguration(Builder builder) {
        this.capture = builder.capture;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isCaptureOn() {
        return this.capture;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayConfiguration config = (ReplayConfiguration)o;
        return this.capture == config.capture;
    }

    public int hashCode() {
        return this.capture ? 1 : 0;
    }

    public String toString() {
        return "ReplayConfiguration{capture=" + this.capture + '}';
    }

    public static class Builder {
        private boolean capture;

        public Builder() {
            this.capture = false;
        }

        public Builder(ReplayConfiguration oldReplayConfiguration) {
            this.capture = oldReplayConfiguration.capture;
        }

        public Builder withCapture(boolean capture) {
            this.capture = capture;
            return this;
        }

        public ReplayConfiguration build() {
            return new ReplayConfiguration(this);
        }
    }
}

