/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.comm.CommunicationProblemListener;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.BuilderUtil;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ConfigurationPreset;
import com.dynatrace.android.agent.conf.InstrumentationMode;
import com.dynatrace.android.agent.util.Utility;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;

public class ConfigurationBuilder {
    protected static final String LOGTAG = Global.LOG_PREFIX + "ConfigurationBuilder";
    private final AgentMode mode;
    private final String applicationId;
    private final String beaconUrl;
    private boolean certificateValidation;
    private KeyStore keyStore;
    private KeyManager[] keyManagers;
    private int graceTime;
    private int waitTime;
    private boolean sendEmptyAction;
    private boolean applicationMonitoring;
    private boolean activityMonitoring;
    private boolean crashReporting;
    private boolean webRequestTiming;
    private String[] monitoredDomains = new String[0];
    private boolean noSendInBg;
    private boolean hybridApp;
    private boolean debugLogLevel;
    private boolean autoStart;
    private CommunicationProblemListener communicationProblemListener;
    private boolean userOptIn;
    private boolean startupLoadBalancing;
    private InstrumentationMode instrumentationMode;

    ConfigurationBuilder(AgentMode mode, String applicationId, String beaconUrl) {
        this(mode, applicationId, beaconUrl, new ConfigurationPreset());
    }

    protected ConfigurationBuilder(AgentMode mode, String applicationId, String beaconUrl, ConfigurationPreset configPreset) {
        this.mode = mode;
        this.applicationId = applicationId;
        this.beaconUrl = beaconUrl;
        this.withCertificateValidation(configPreset.getCertificateValidation());
        this.withHybridMonitoring(configPreset.getHybridApp());
        this.withDebugLogging(configPreset.getDebugLogLevel());
        this.withUserOptIn(configPreset.getUserOptIn());
        this.withMonitoredDomains(configPreset.getMonitoredDomains());
        this.withStartupLoadBalancing(configPreset.getStartupLoadBalancing());
        this.graceTime = configPreset.getGraceTime();
        this.waitTime = configPreset.getWaitTime();
        this.applicationMonitoring = configPreset.getApplicationMonitoring();
        this.activityMonitoring = configPreset.getActivityMonitoring();
        this.webRequestTiming = configPreset.getWebRequestTiming();
        this.noSendInBg = configPreset.getNoSendInBg();
        this.autoStart = configPreset.getAutoStart();
        this.crashReporting = configPreset.getCrashReporting();
        this.sendEmptyAction = configPreset.getSendEmptyActions();
        this.communicationProblemListener = null;
        this.keyStore = null;
        this.keyManagers = null;
        this.instrumentationMode = configPreset.getInstrumentationMode();
    }

    public ConfigurationBuilder withCertificateValidation(boolean enabled) {
        this.certificateValidation = enabled;
        return this;
    }

    public ConfigurationBuilder withKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public ConfigurationBuilder withKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
        return this;
    }

    public ConfigurationBuilder withMonitoredDomains(String ... monitoredDomains) {
        String[] newValue = BuilderUtil.truncateStrings(monitoredDomains);
        if (newValue != null) {
            this.monitoredDomains = newValue;
        }
        return this;
    }

    public ConfigurationBuilder withHybridMonitoring(boolean enabled) {
        this.hybridApp = enabled;
        return this;
    }

    public ConfigurationBuilder withDebugLogging(boolean enabled) {
        this.debugLogLevel = enabled;
        return this;
    }

    public ConfigurationBuilder withUserOptIn(boolean enabled) {
        this.userOptIn = enabled;
        return this;
    }

    public ConfigurationBuilder withStartupLoadBalancing(boolean enabled) {
        if (this.mode != AgentMode.APP_MON) {
            this.startupLoadBalancing = enabled;
        }
        return this;
    }

    public ConfigurationBuilder withCrashReporting(boolean enabled) {
        this.crashReporting = enabled;
        return this;
    }

    public ConfigurationBuilder withCommunicationProblemListener(CommunicationProblemListener listener) {
        this.communicationProblemListener = listener;
        return this;
    }

    public Configuration buildConfiguration() {
        String errorMsg = "discard invalid configuration";
        if (this.beaconUrl == null || this.mode == null) {
            if (this.debugLogLevel) {
                Utility.zlogE(LOGTAG, "discard invalid configuration");
            }
            return null;
        }
        String verifiedBeaconUrl = BuilderUtil.getVerifiedBeaconUrl(this.beaconUrl, this.mode != AgentMode.APP_MON);
        if (verifiedBeaconUrl == null) {
            if (this.debugLogLevel) {
                Utility.zlogE(LOGTAG, "invalid value for the beacon url \"" + this.beaconUrl + "\"");
                Utility.zlogE(LOGTAG, "discard invalid configuration");
            }
            return null;
        }
        String appIdTruncated = BuilderUtil.truncateString(this.applicationId);
        if (appIdTruncated == null) {
            if (this.debugLogLevel) {
                Utility.zlogE(LOGTAG, "invalid value for application id \"" + this.applicationId + "\"");
                Utility.zlogE(LOGTAG, "discard invalid configuration");
            }
            return null;
        }
        String appIdEncoded = Utility.urlEncode(Utility.trimString(appIdTruncated, 250)).replaceAll("_", "%5F");
        return new Configuration(appIdEncoded, verifiedBeaconUrl, this.mode, this.certificateValidation, this.keyStore, this.keyManagers, this.graceTime, this.waitTime, this.sendEmptyAction, this.applicationMonitoring, this.activityMonitoring, this.crashReporting, this.webRequestTiming, this.monitoredDomains, this.noSendInBg, this.hybridApp, this.debugLogLevel, this.autoStart, this.communicationProblemListener, this.userOptIn, this.startupLoadBalancing, this.instrumentationMode);
    }
}

