/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.WebReqSegment;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class WebRequestTiming {
    private static final String LOGTAG = Global.LOG_PREFIX + "WebRequestTiming";
    private WebReqTag webReqTag;
    private boolean mFinalized = false;
    private long mEventStartTime = -1L;
    private long mEventEndTime = -1L;
    private HttpURLConnection userConnection = null;

    protected WebRequestTiming(String tag) {
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "Creating new web request timing for tag " + tag);
        }
        this.webReqTag = WebReqTag.parseTag(tag, Session.currentSession());
    }

    protected WebRequestTiming(HttpURLConnection connection) {
        this(WebRequestTiming.getTag(connection));
        this.userConnection = connection;
    }

    private static String getTag(HttpURLConnection conn) {
        if (conn != null) {
            String tag = conn.getRequestProperty(Dynatrace.getRequestTagHeader());
            if (tag == null) {
                Dynatrace.tagRequest(conn);
            }
            return conn.getRequestProperty(Dynatrace.getRequestTagHeader());
        }
        return null;
    }

    public void startWebRequestTiming() {
        if (this.webReqTag == null || this.isFinalized()) {
            return;
        }
        this.mEventStartTime = this.webReqTag.getSession().getRunningTime();
    }

    public void stopWebRequestTiming(String requestUrl, int respCode, String respPhrase) throws MalformedURLException {
        this.stopWebRequestTiming(new URL(requestUrl), respCode, respPhrase);
    }

    public void stopWebRequestTiming(URL requestUrl, int respCode, String respPhrase) {
        if (requestUrl == null) {
            throw new IllegalArgumentException("The argument \"requestUrl\" must not be null");
        }
        if (this.mEventStartTime == -1L || this.webReqTag == null) {
            return;
        }
        if (this.isFinalized()) {
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            this.mFinalized = true;
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "Creating web timing event for " + this.webReqTag.toString());
        }
        this.updateEndTime(this.webReqTag.getSession().getRunningTime());
        WebReqSegment segment = new WebReqSegment(this.webReqTag.getParentTagId(), this.webReqTag.getSeqNumber(), this.mEventStartTime, this.mEventEndTime, respCode, respPhrase, Utility.trimWebRequest(requestUrl.toString()), -1L, -1L, this.webReqTag.getSession(), this.webReqTag.getServerId());
        Core.saveSegment(segment);
    }

    private void updateEndTime(long endTime) {
        if (!this.mFinalized) {
            this.mEventEndTime = endTime;
            this.mFinalized = true;
        }
    }

    public boolean isFinalized() {
        return this.mFinalized;
    }

    public void stopWebRequestTiming() {
        if (this.userConnection == null) {
            Utility.zlogE(LOGTAG, "Invalid usage of stopWebRequestTiming().");
            return;
        }
        try {
            this.stopWebRequestTiming(this.userConnection.getURL(), this.userConnection.getResponseCode(), this.userConnection.getResponseMessage());
        }
        catch (IOException e) {
            if (Global.DEBUG) {
                Utility.zlogE(LOGTAG, "Unable to retrieve status information for web timing request.", e);
            }
            this.stopWebRequestTiming(this.userConnection.getURL(), 0, e.getMessage());
        }
    }
}

