/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.ActionThreadLocal;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.LcState;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.app.LcContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class LcAction
extends DTXActionImpl {
    private static final String LOGTAG = Global.LOG_PREFIX + "LcAction";
    private String activityName = "unknown";
    private long onCreateTime = -1L;
    private long onStartTime = -1L;
    private long onResumeTime = -1L;
    private int onCreateSequenceNumber = -1;
    private int onStartSequenceNumber = -1;
    private int onResumeSequenceNumber = -1;
    private int onPostResumeSequenceNumber = -1;

    private LcAction(String actionName, EventType eventType, long parentTagId, Session session, int serverId) {
        super(actionName, eventType, parentTagId, session, serverId);
    }

    public static LcAction createAction(String actionName, EventType eventType, DTXAutoAction parentAction) {
        int serverId;
        Session session;
        long parentTagId = 0L;
        if (parentAction != null && !parentAction.isFinalized()) {
            parentTagId = parentAction.getTagId();
            session = parentAction.session;
            serverId = parentAction.serverId;
        } else {
            session = Session.determineActiveSession(false, false);
            serverId = AdkSettings.getInstance().serverId;
        }
        if (actionName == null || actionName.isEmpty()) {
            actionName = "null";
        }
        LcAction action = new LcAction(actionName, eventType, parentTagId, session, serverId);
        if (parentTagId != 0L) {
            action.parentAction = parentAction;
            action.numberOfParentActions = parentAction.numberOfParentActions + 1;
            parentAction.addChildEvent(action);
            if (action.numberOfParentActions >= 10) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, "Maximum depth of actions reached (10). Discarding creation of '" + action.getName() + "'");
                }
                return action;
            }
        }
        ActionThreadLocal.addAction(action);
        Core.addEvent(actionName, 1, parentTagId, action, session, serverId, new String[0]);
        return action;
    }

    public void addChildEvent(String eventName) {
        CustomSegment cs = new CustomSegment(eventName, 120, EventType.PLACEHOLDER, this.getTagId(), this.session, this.serverId);
        this.addChildEvent(cs);
    }

    @Override
    public void leaveAction() {
        if (this.isFinalized()) {
            return;
        }
        this.processFormEvents();
        switch (this.getEventType()) {
            case APP_START: {
                LcContext.getInstance().cleanUpAppStart(this);
                break;
            }
            case DISPLAY: 
            case REDISPLAY: {
                LcContext.getInstance().cleanUpDisplay(this);
            }
        }
        super.leaveAction();
    }

    private void processFormEvents() {
        Vector<CustomSegment> childVectors = this.getChildEventVector();
        ArrayList<LcState> targetLifecycleEvents = new ArrayList<LcState>();
        HashMap<LcState, CustomSegment> mappedEvents = new HashMap<LcState, CustomSegment>();
        targetLifecycleEvents.add(LcState.onActivityCreate);
        targetLifecycleEvents.add(LcState.onActivityStart);
        targetLifecycleEvents.add(LcState.onActivityResume);
        targetLifecycleEvents.add(LcState.onActivityPostResume);
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, childVectors.size() + " children of action " + this.getName());
        }
        for (CustomSegment customSegment : childVectors) {
            LcState eventName = null;
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "\t" + customSegment.getName());
            }
            try {
                eventName = LcState.valueOf(customSegment.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (eventName == null || !targetLifecycleEvents.contains((Object)eventName)) continue;
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("\t\tMap event %s", customSegment.getName()));
            }
            mappedEvents.put(eventName, customSegment);
        }
        for (Map.Entry entry : mappedEvents.entrySet()) {
            long time = ((CustomSegment)entry.getValue()).getStartTime();
            int seqNo = ((CustomSegment)entry.getValue()).getLcSeqNum();
            switch ((LcState)((Object)entry.getKey())) {
                case onActivityCreate: {
                    this.setOnCreateTime(time);
                    this.setOnCreateSequenceNumber(seqNo);
                    break;
                }
                case onActivityStart: {
                    this.setOnStartTime(time);
                    this.setOnStartSequenceNumber(seqNo);
                    break;
                }
                case onActivityResume: {
                    this.setOnResumeTime(time);
                    this.setOnResumeSequenceNumber(seqNo);
                    break;
                }
                case onActivityPostResume: {
                    this.setOnPostResumeSequenceNumber(seqNo);
                    break;
                }
            }
        }
    }

    @Override
    protected boolean getPreconditions() {
        if (this.isFinalized()) {
            return false;
        }
        return Core.shouldCollectLcData();
    }

    private long getOnCreateTime() {
        return this.onCreateTime;
    }

    private void setOnCreateTime(long onCreateTime) {
        this.onCreateTime = onCreateTime;
    }

    private long getOnStartTime() {
        return this.onStartTime;
    }

    private void setOnStartTime(long onStartTime) {
        this.onStartTime = onStartTime;
    }

    private int getOnCreateSequenceNumber() {
        return this.onCreateSequenceNumber;
    }

    private void setOnCreateSequenceNumber(int onCreateSequenceNumber) {
        this.onCreateSequenceNumber = onCreateSequenceNumber;
    }

    private int getOnStartSequenceNumber() {
        return this.onStartSequenceNumber;
    }

    private void setOnStartSequenceNumber(int onStartSequenceNumber) {
        this.onStartSequenceNumber = onStartSequenceNumber;
    }

    protected int getOnPostResumeSequenceNumber() {
        return this.onPostResumeSequenceNumber;
    }

    private void setOnPostResumeSequenceNumber(int onPostResumeSequenceNumber) {
        this.onPostResumeSequenceNumber = onPostResumeSequenceNumber;
    }

    private String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    private long getOnResumeTime() {
        return this.onResumeTime;
    }

    private void setOnResumeTime(long onResumeTime) {
        this.onResumeTime = onResumeTime;
    }

    private int getOnResumeSequenceNumber() {
        return this.onResumeSequenceNumber;
    }

    private void setOnResumeSequenceNumber(int onResumeSequenceNumber) {
        this.onResumeSequenceNumber = onResumeSequenceNumber;
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.getEventType().getProtocolId());
        switch (this.getEventType()) {
            case APP_START: {
                if (this.getActivityName() != null && !this.getActivityName().equals("unknown")) {
                    sb.append("&na=").append(Utility.urlEncode(this.getActivityName()));
                }
                sb.append("&it=").append(Thread.currentThread().getId());
                sb.append("&ca=").append(this.getTagId());
                sb.append("&pa=").append(this.getParentTagId());
                sb.append("&s0=").append(this.getLcSeqNum());
                sb.append("&t0=").append(this.getStartTime());
                sb.append("&s1=").append(Utility.getEventSeqNum());
                sb.append("&t1=").append(this.session.getRunningTime() - this.getStartTime());
                break;
            }
            case DISPLAY: {
                sb.append("&na=").append(Utility.urlEncode(this.getActivityName()));
                sb.append("&it=").append(Thread.currentThread().getId());
                sb.append("&ca=").append(this.getTagId());
                sb.append("&pa=").append(this.getParentTagId());
                sb.append("&s0=").append(this.getLcSeqNum());
                sb.append("&t0=").append(this.getStartTime());
                long durationOnCreate = this.getOnCreateTime() - this.getStartTime();
                if (this.getOnCreateSequenceNumber() >= 0 && durationOnCreate >= 0L) {
                    sb.append("&s1=").append(this.getOnCreateSequenceNumber());
                    sb.append("&t1=").append(durationOnCreate);
                }
                long durationOnStart = this.getOnStartTime() - this.getStartTime();
                if (this.getOnStartSequenceNumber() >= 0 && durationOnStart >= 0L) {
                    sb.append("&s2=").append(this.getOnStartSequenceNumber());
                    sb.append("&t2=").append(durationOnStart);
                }
                long durationOnResume = this.getOnResumeTime() - this.getStartTime();
                if (this.getOnResumeSequenceNumber() < 0 || durationOnResume < 0L) break;
                sb.append("&s3=").append(this.getOnResumeSequenceNumber());
                sb.append("&t3=").append(durationOnResume);
                break;
            }
            case REDISPLAY: {
                sb.append("&na=").append(Utility.urlEncode(this.getActivityName()));
                sb.append("&it=").append(Thread.currentThread().getId());
                sb.append("&ca=").append(this.getTagId());
                sb.append("&pa=").append(this.getParentTagId());
                sb.append("&s0=").append(this.getLcSeqNum());
                sb.append("&t0=").append(this.getStartTime());
                long durationOnStart = this.getOnStartTime() - this.getStartTime();
                if (this.getOnStartSequenceNumber() >= 0 && durationOnStart >= 0L) {
                    sb.append("&s2=").append(this.getOnStartSequenceNumber());
                    sb.append("&t2=").append(durationOnStart);
                }
                long durationOnResume = this.getOnResumeTime() - this.getStartTime();
                if (this.getOnResumeSequenceNumber() < 0 || durationOnResume < 0L) break;
                sb.append("&s3=").append(this.getOnResumeSequenceNumber());
                sb.append("&t3=").append(durationOnResume);
                break;
            }
        }
        return sb;
    }
}

