/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.webkit.WebView;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXAction;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.JavascriptAgentInterface;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.UserActionModifier;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.WebRequestTiming;
import com.dynatrace.android.agent.comm.HttpConstants;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.DataCollectionLevel;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.UserPrivacyOptions;
import com.dynatrace.android.agent.crash.CrashCatcher;
import com.dynatrace.android.agent.crash.JavaStacktraceProcessor;
import com.dynatrace.android.agent.crash.PlatformType;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.app.LcContext;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class Dynatrace {
    static final String ILLEGAL_STATE_ERROR = AdkSettings.getADKName() + " not running";
    private static final String JS_INTERFACE_NAME = "MobileAgent";
    private static final String LOGTAG = Global.LOG_PREFIX + "Dynatrace";
    private static final String HEADER = "x-dynatrace";
    private static final Object mOperationPending = new Object();
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(Context context, Configuration configuration) {
        if (context == null || configuration == null) {
            return;
        }
        if (!Utility.hasPermissions(context)) {
            return;
        }
        Object object = mOperationPending;
        synchronized (object) {
            block8: {
                if (isInitialized.get()) {
                    return;
                }
                try {
                    Core.startup(context, configuration);
                    isInitialized.set(true);
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block8;
                    Utility.zlogD(LOGTAG, "unable to start agent", e);
                }
            }
        }
    }

    public static void shutdown() {
        Dynatrace.shutdown(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown(final long lStopTimeLimitSec) {
        Object object = mOperationPending;
        synchronized (object) {
            if (!isInitialized.compareAndSet(true, false)) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, "Not initialized - skip shutdown");
                }
                return;
            }
            CrashCatcher.uninstallUncaughtExceptionHandler();
            CrashCatcher.unregisterUncaughtExceptionListener(Core.getCrashListener());
            Core.communicationManager.stopTimerLoop();
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = mOperationPending;
                synchronized (object) {
                    Core.shutdown(lStopTimeLimitSec);
                }
            }
        };
        t.start();
    }

    protected static void pause() {
        if (!isInitialized.get()) {
            return;
        }
        if (AdkSettings.getInstance().noSendInBg) {
            Core.communicationManager.stopTimerLoop();
        }
        Core.flushEvents();
    }

    protected static void resume() {
        if (!isInitialized.get()) {
            return;
        }
        if (Core.dao != null) {
            Core.dao.deleteOldEvents(TimeLineProvider.getSystemTime(), AdkSettings.getInstance().getServerConfiguration().isCachingCrashes());
        }
        Core.communicationManager.startTimerLoop(false);
    }

    public static boolean getCaptureStatus() {
        if (!isInitialized.get()) {
            return false;
        }
        return Core.getCaptureState();
    }

    public static void setGpsLocation(Location location) {
        Core.setGpsLocation(location);
    }

    public static String getRequestTagHeader() {
        return HEADER;
    }

    public static String getRequestTag() {
        return WebReqTag.tagToString(Core.getRequestTag());
    }

    public static void tagRequest(HttpURLConnection conn) {
        block3: {
            if (conn == null || !Dynatrace.getCaptureStatus()) {
                return;
            }
            try {
                conn.setRequestProperty(Dynatrace.getRequestTagHeader(), WebReqTag.tagToString(Core.getRequestTag()));
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block3;
                Utility.zlogE(LOGTAG, e.toString());
            }
        }
    }

    public static DTXAction enterAction(String actionName) {
        return DTXActionImpl.createAction(actionName, null);
    }

    public static DTXAction enterAction(String actionName, DTXAction parentAction) {
        return DTXActionImpl.createAction(actionName, parentAction);
    }

    public static void endVisit() {
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Core.endVisit();
    }

    public static void reportError(String errorName, int errorCode) {
        Dynatrace.reportError(errorName, 9, String.valueOf(errorCode));
    }

    public static void reportError(String errorName, Throwable throwable) {
        if (errorName == null) {
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        int maxLines = AdkSettings.getInstance().getConfiguration().mode == AgentMode.APP_MON ? 10 : Integer.MAX_VALUE;
        StacktraceData stacktraceData = throwable == null ? new StacktraceData(null, null, null, PlatformType.JAVA) : new JavaStacktraceProcessor(throwable, maxLines).process();
        Dynatrace.reportError(errorName, 10, stacktraceData.getName(), stacktraceData.getReason(), stacktraceData.getStacktrace(), stacktraceData.getType().getProtocolValue());
    }

    static void reportError(PlatformType type, String errorName, String errorValue, String reason, String stacktrace) {
        if (type == null || errorName == null) {
            return;
        }
        Dynatrace.reportError(errorName, 10, Utility.trimString(errorValue, 250), Utility.trimString(reason, 1000), Utility.trimString(stacktrace, 128000), type.getProtocolValue());
    }

    static void reportCrash(PlatformType type, String crashName, String reason, String stacktrace) {
        if (type == null || crashName == null) {
            return;
        }
        Dynatrace.reportCrash(crashName, 11, Utility.trimString(reason, 1000), Utility.trimString(stacktrace, 128000), type.getProtocolValue());
    }

    static void createNewSession() {
        Core.startNewSession(true, Session.currentSession().getPrivacyRules());
    }

    private static void reportCrash(String errorName, int eventType, String ... values) {
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Session session = Session.determineActiveSession(false, false);
        if (!Core.shouldSendCrashData(session)) {
            return;
        }
        int serverId = AdkSettings.getInstance().serverId;
        Core.addEvent(errorName, eventType, 0L, null, session, serverId, values);
    }

    private static void reportError(String errorName, int eventType, String ... values) {
        if (!Dynatrace.getCaptureStatus() || !Core.shouldSendErrorData()) {
            return;
        }
        Session session = Session.determineActiveSession(false, false);
        int serverId = AdkSettings.getInstance().serverId;
        Core.addEvent(errorName, eventType, 0L, null, session, serverId, values);
    }

    public static void flushEvents() {
        Core.flushEvents();
    }

    public static void setBeaconHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            HttpConstants.customBeaconHeaders = null;
        } else {
            HashMap<String, String> copy = new HashMap<String, String>(headers);
            HttpConstants.customBeaconHeaders = copy;
            if (isInitialized.get()) {
                Core.communicationManager.scheduleNewBeaconRequest();
            }
        }
    }

    public static WebRequestTiming getWebRequestTiming(String tag) {
        return new WebRequestTiming(tag);
    }

    public static WebRequestTiming getWebRequestTiming(HttpURLConnection connection) {
        return new WebRequestTiming(connection);
    }

    public static void identifyUser(String userId) {
        Dynatrace.identifyUser(userId, null);
    }

    public static void identifyUser(String userId, DTXAction parentAction) {
        int serverId;
        Session session;
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        long parentTagId = 0L;
        DTXActionImpl parentActionImpl = null;
        if (parentAction instanceof DTXActionImpl) {
            parentActionImpl = (DTXActionImpl)parentAction;
            if (parentActionImpl.numberOfParentActions >= 10) {
                return;
            }
        }
        if (parentActionImpl != null && !parentActionImpl.isFinalized()) {
            parentTagId = parentActionImpl.getTagId();
            session = parentActionImpl.session;
            serverId = parentActionImpl.getServerId();
        } else {
            session = Session.determineActiveSession(false, false);
            serverId = AdkSettings.getInstance().serverId;
        }
        CustomSegment oaSeg = Core.addEvent(userId, 12, parentTagId, parentActionImpl, session, serverId, new String[0]);
        if (oaSeg == null) {
            return;
        }
        if (parentTagId != 0L) {
            parentActionImpl.addChildEvent(oaSeg);
        }
    }

    public static UserPrivacyOptions getUserPrivacyOptions() {
        if (!isInitialized.get()) {
            return PrivacyRules.PRIVACY_MODE_DEACTIVATED.getPrivacySettings();
        }
        return Session.currentSession().getPrivacyRules().getPrivacySettings();
    }

    public static void applyUserPrivacyOptions(UserPrivacyOptions userPrivacyOptions) {
        if (!isInitialized.get()) {
            return;
        }
        if (!AdkSettings.getInstance().getConfiguration().userOptIn) {
            return;
        }
        if (userPrivacyOptions.equals(Dynatrace.getUserPrivacyOptions())) {
            return;
        }
        AdkSettings.getInstance().preferencesManager.storePrivacySettings(userPrivacyOptions);
        LcContext.getInstance().resetLifecycleData();
        Core.startNewSession(true, new PrivacyRules(userPrivacyOptions));
    }

    @Deprecated
    public static boolean isCrashReportingOptedIn() {
        if (!isInitialized.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        return Dynatrace.getUserPrivacyOptions().isCrashReportingOptedIn();
    }

    @Deprecated
    public static void setCrashReportingOptedIn(boolean confirmed) {
        if (!isInitialized.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        Dynatrace.applyUserPrivacyOptions(Dynatrace.getUserPrivacyOptions().newBuilder().withCrashReportingOptedIn(confirmed).build());
    }

    @Deprecated
    public static DataCollectionLevel getDataCollectionLevel() {
        if (!isInitialized.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        return Dynatrace.getUserPrivacyOptions().getDataCollectionLevel();
    }

    @Deprecated
    public static void setDataCollectionLevel(DataCollectionLevel dataCollectionLevel) {
        if (!isInitialized.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        Dynatrace.applyUserPrivacyOptions(Dynatrace.getUserPrivacyOptions().newBuilder().withDataCollectionLevel(dataCollectionLevel).build());
    }

    static DTXAction integrateNewAction(String actionName) {
        DTXAutoAction gaua = DTXAutoAction.getAutoAction();
        if (gaua != null) {
            return DTXActionImpl.createAction(actionName, gaua);
        }
        Session session = Session.determineActiveSession(false, true);
        int serverId = AdkSettings.getInstance().serverId;
        DTXAutoAction globalAction = DTXAutoAction.createAutoAction(actionName, session, serverId);
        globalAction.startTimer(1000);
        return globalAction;
    }

    public static void modifyUserAction(UserActionModifier modifier) {
        Core.modifyUserAction(modifier);
    }

    public static void instrumentWebView(WebView webView) {
        if (Build.VERSION.SDK_INT < 17) {
            if (Global.DEBUG) {
                Utility.zlogE(LOGTAG, "Method instrumentWebView(WebView) can't be used with API level " + Build.VERSION.SDK_INT);
            }
            return;
        }
        if (webView != null && AdkSettings.getInstance().hybridApp) {
            webView.getSettings().setJavaScriptEnabled(true);
            webView.addJavascriptInterface((Object)new JavascriptAgentInterface(), JS_INTERFACE_NAME);
        }
    }

    public static void restoreCookies() {
        if (isInitialized.get()) {
            if (Global.DEBUG) {
                Utility.zlogD(Global.LOG_PREFIX, "restore cookies");
            }
            Core.restoreCookies();
        }
    }
}

