/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.ErrorSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;

public class CrashSegment
extends ErrorSegment {
    public CrashSegment(String exceptionName, String reason, String stacktrace, long parentTagId, Session session, int serverId, String platformType) {
        super(exceptionName, 11, EventType.CRASH, exceptionName, reason, stacktrace, parentTagId, session, serverId, platformType);
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.eventType.getProtocolId());
        sb.append("&na=").append(Utility.urlEncode(this.getName()));
        sb.append("&it=").append(Thread.currentThread().getId());
        sb.append("&pa=").append(this.getParentTagId());
        sb.append("&s0=").append(this.lcSeqNum);
        sb.append("&t0=").append(this.getStartTime());
        this.appendOptionalValue(sb, "&rs=", Utility.urlEncode(this.reason));
        this.appendOptionalValue(sb, "&st=", Utility.urlEncode(this.stacktrace));
        sb.append("&tt=").append(this.platformType);
        return sb;
    }

    public static class CrashSegmentModifier {
        public String convertToStandaloneCrash(String segment) {
            int indexStart = segment.indexOf("&pa=");
            if (indexStart < 0) {
                return segment;
            }
            int indexEnd = segment.indexOf("&", indexStart + 1);
            if (indexEnd < 0) {
                indexEnd = segment.length();
            }
            return segment.replace(segment.substring(indexStart, indexEnd), "&pa=0");
        }
    }
}

