/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.BasicSegment;
import com.dynatrace.android.agent.CommunicationManager;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CrashSegment;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.InstrumentationMode;
import com.dynatrace.android.agent.crash.CrashListener;
import com.dynatrace.android.agent.crash.PlatformType;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.crash.StacktraceProcessorFactory;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.app.LcContext;

public class CrashReporter
implements CrashListener {
    private static final String LOGTAG = Global.LOG_PREFIX + "CrashReporter";
    protected static boolean hasCrashed = false;
    protected CommunicationManager communicationManager;
    private final StacktraceProcessorFactory processorFactory;

    public CrashReporter(CommunicationManager communicationManager) {
        this.communicationManager = communicationManager;
        this.processorFactory = new StacktraceProcessorFactory();
    }

    protected static boolean hasCrashed() {
        return hasCrashed;
    }

    @Override
    public synchronized void notifyCustomCrash(String platformType, String crashName, String reason, String stacktrace) {
    }

    @Override
    public synchronized void notifyJavaCrash(Thread thread, Throwable t) {
        int serverId;
        Session session;
        hasCrashed = true;
        if (!Dynatrace.getCaptureStatus()) {
            if (Global.DEBUG) {
                Utility.zlogI(LOGTAG, "Not reporting uncaught exception due to capturing state is off");
            }
            return;
        }
        DTXActionImpl action = this.findWrapCrashEvent();
        if (action != null) {
            session = action.session;
            serverId = action.serverId;
        } else {
            session = Session.determineActiveSession(true, false);
            serverId = AdkSettings.getInstance().serverId;
        }
        this.communicationManager.stopTimerLoop();
        if (session.isActive()) {
            this.reportCrash(thread, t, Core.shouldSendCrashData(session), action, session, serverId);
        }
        Core.shutdown(5000L);
    }

    protected void reportCrash(Thread thread, Throwable throwable, boolean shouldSendCrashData, DTXActionImpl action, Session session, int serverId) {
        if (Global.DEBUG) {
            Utility.zlogE(LOGTAG, String.format("Processing exception (in thread %s) ...", thread != null ? thread.getName() : "unknown"), throwable);
        }
        if (shouldSendCrashData) {
            InstrumentationMode instrMode = AdkSettings.getInstance().getConfiguration().instrumentationMode;
            StacktraceData stacktraceData = this.processorFactory.determineCrashProcessor(throwable, instrMode).process();
            CrashSegment oaSeg = this.getCrashSegment(stacktraceData.getName(), stacktraceData.getReason(), stacktraceData.getStacktrace(), action, session, serverId, stacktraceData.getType());
            String updatableData = new BasicSegment.UpdatableDataGenerator().generateUpdatableData(session.sessionStartTime, session.multiplicity);
            if (!this.communicationManager.sendCrashData(oaSeg, Core.getOcvbString(oaSeg.session) + updatableData, serverId)) {
                Core.saveSegment(oaSeg);
            }
        }
        LcContext.getInstance().forceCloseActiveActions("an crash");
    }

    protected DTXActionImpl findWrapCrashEvent() {
        DTXActionImpl action = LcContext.getInstance().getCurrentAction();
        if (action == null && (action = DTXAutoAction.getAutoAction()) != null) {
            ((DTXAutoAction)action).markOverrideEndTime();
        }
        if (action != null && !action.isFinalized()) {
            return action;
        }
        return null;
    }

    private CrashSegment getCrashSegment(String crashEventName, String reason, String stackTrace, DTXActionImpl action, Session session, int serverId, PlatformType type) {
        CrashSegment oaSegment = new CrashSegment(crashEventName, reason, stackTrace, 0L, session, serverId, type.getProtocolValue());
        if (action != null) {
            oaSegment.setParentTagId(action.getTagId());
            action.addChildEvent(oaSegment);
        }
        return oaSegment;
    }
}

