/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CalloutTable {
    private static final String TAG = Global.LOG_PREFIX + "CalloutTable";
    private long mSendTimeout;
    private long mCurrentTimeout;
    private List<CTElement> mTable;
    private Vector<PendingItem> mPendingLcActions = null;
    private Object mPendingLcActionsSyncObj = new Object();

    public CalloutTable(int sendTimeout) {
        this.mTable = new ArrayList<CTElement>();
        this.mSendTimeout = sendTimeout;
        this.mCurrentTimeout = 0L;
    }

    public void addPendingItem(CustomSegment segment) {
        int numItem = 5;
        if (this.mPendingLcActions == null) {
            this.mPendingLcActions = new Vector(numItem);
        }
        this.mPendingLcActions.add(new PendingItem(segment));
        if (this.mPendingLcActions.size() > numItem) {
            this.removeExpiredPendingItems();
        }
    }

    private void removeExpiredPendingItems() {
        long now = TimeLineProvider.getSystemTime();
        Vector<PendingItem> copy = new Vector<PendingItem>(this.mPendingLcActions);
        while (copy.size() > 0) {
            PendingItem item = copy.remove(0);
            if (now - item.time <= 540000L) continue;
            this.mPendingLcActions.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<PendingItem> removePendingItems() {
        if (this.mPendingLcActions == null || this.mPendingLcActions.size() < 1) {
            return null;
        }
        Object object = this.mPendingLcActionsSyncObj;
        synchronized (object) {
            Vector<PendingItem> v = this.mPendingLcActions;
            this.mPendingLcActions = null;
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionEvent(CustomSegment segment) {
        if (segment == null) {
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("Add segment %s (id=%d pid=%d) currTimeout=%s", segment.getName() + segment.hashCode(), segment.getTagId(), segment.getParentTagId(), this.mCurrentTimeout));
        }
        List<CTElement> list = this.mTable;
        synchronized (list) {
            long timeout = this.mSendTimeout - this.mCurrentTimeout;
            for (int i = 0; i < this.mTable.size(); ++i) {
                if (this.mTable.get(i).timeout >= timeout) {
                    CTElement cTElement = this.mTable.get(i);
                    cTElement.timeout = cTElement.timeout - timeout;
                    this.mTable.add(i, new CTElement(segment, timeout));
                    return;
                }
                timeout -= this.mTable.get(i).timeout;
            }
            this.mTable.add(new CTElement(segment, timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherEvent() {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            if (this.mTable.size() > 0) {
                return;
            }
            if (this.mCurrentTimeout == 0L) {
                this.mCurrentTimeout = this.mSendTimeout;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeActionSendEvent(CustomSegment segment) {
        if (segment == null) {
            return false;
        }
        String id = segment.getName() + segment.hashCode();
        List<CTElement> list = this.mTable;
        synchronized (list) {
            for (int i = 0; i < this.mTable.size(); ++i) {
                if (!this.mTable.get(i).actionId.equals(id)) continue;
                if (i + 1 < this.mTable.size()) {
                    CTElement cTElement = this.mTable.get(i + 1);
                    cTElement.timeout = cTElement.timeout + this.mTable.get(i).timeout;
                } else if (this.mCurrentTimeout == 0L) {
                    this.mCurrentTimeout = this.mTable.get(i).timeout;
                }
                CTElement obj = this.mTable.remove(i);
                return obj != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSendEventTimeout(long newTimeout) {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            if (newTimeout == this.mSendTimeout) {
                return;
            }
            this.mSendTimeout = newTimeout;
            if (this.mCurrentTimeout > newTimeout) {
                if (this.mTable.size() > 0) {
                    CTElement cTElement = this.mTable.get(0);
                    cTElement.timeout = cTElement.timeout + (this.mCurrentTimeout - newTimeout);
                }
                this.mCurrentTimeout = newTimeout;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isItTimeToSend() {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            if (this.mCurrentTimeout > 0L) {
                boolean bl = --this.mCurrentTimeout == 0L;
                return bl;
            }
            if (this.mTable.size() > 0 && --this.mTable.get(0).timeout == 0L) {
                do {
                    this.mTable.remove(0);
                } while (this.mTable.size() > 0 && this.mTable.get(0).timeout == 0L);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        List<CTElement> list = this.mTable;
        synchronized (list) {
            this.mTable.clear();
            this.mCurrentTimeout = 0L;
        }
    }

    public String toString() {
        String s = this.mCurrentTimeout + ";";
        for (int i = 0; i < this.mTable.size(); ++i) {
            s = s + this.mTable.get(i).timeout + ";";
        }
        return s;
    }

    void storePendingEvents() {
        Vector<PendingItem> pendingItems = this.removePendingItems();
        if (pendingItems != null) {
            while (pendingItems.size() > 0) {
                Core.persistEventCmn(pendingItems.remove(0).data);
            }
        }
    }

    private class CTElement {
        private String actionId;
        private long timeout;

        public CTElement(CustomSegment segment, long timeout) {
            this.actionId = segment.getName() + segment.hashCode();
            this.timeout = timeout;
        }
    }

    public class PendingItem {
        private CustomSegment data;
        private long time;

        private PendingItem(CustomSegment segment) {
            this.data = segment;
            this.time = TimeLineProvider.getSystemTime();
        }
    }
}

