/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.CbURIDesc;
import com.dynatrace.android.callback.WebReqStateParms;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;

class UriReqStateParms
extends WebReqStateParms {
    private static final String LOGTAG = "caa-aUriReqStateParms";
    private HttpUriRequest uriRequest;
    private HttpRequest request;
    private HttpHost host;
    private HttpContext httpContext;
    private CbURIDesc uriDesc;

    UriReqStateParms(HttpHost host, HttpRequest request, HttpContext context) {
        super(CbConstants.WrMethod.execute, CbConstants.WrStates.PRE_EXEC, 0);
        this.host = host;
        this.request = request;
        this.httpContext = context;
        this.uriDesc = CbURIDesc.createURIDesc(request, host);
        if (request != null && request instanceof HttpUriRequest) {
            this.uriRequest = (HttpUriRequest)request;
        }
    }

    HttpRequest getRequest() {
        return this.request;
    }

    HttpHost getExecHost() {
        return this.host;
    }

    URL getUrl() {
        if (this.uriDesc.uri != null) {
            try {
                return this.uriDesc.uri.toURL();
            }
            catch (MalformedURLException e) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOGTAG, (String)e.toString(), (Throwable)e);
                }
                return null;
            }
            catch (Exception e) {
                if (Global.DEBUG) {
                    Utility.zlogW((String)LOGTAG, (String)e.toString());
                }
                return null;
            }
        }
        return null;
    }

    String getRequestDesc() {
        if (this.desc != null) {
            return this.desc;
        }
        this.desc = this.uriDesc.desc;
        return this.desc;
    }

    String getRequestHost() {
        return this.uriDesc.host;
    }

    String getRequestMethod() {
        RequestLine reqLine;
        if (this.uriRequest != null) {
            return this.uriRequest.getMethod();
        }
        if (this.request instanceof HttpEntityEnclosingRequest && (reqLine = this.request.getRequestLine()) != null) {
            return reqLine.getMethod();
        }
        return "NA";
    }

    protected String getRequestClassName() {
        return this.getRequestClassName(this.request);
    }

    private static long calcHttpResponseLength(HttpResponse httpResponse) {
        int firstLineBytes = httpResponse.getStatusLine().toString().length() + 2;
        Header[] headers = httpResponse.getAllHeaders();
        int headerLength = 2;
        long contentLength = 0L;
        boolean searchForContentLengthHeader = true;
        for (Header header : headers) {
            headerLength += header.toString().length() + 2;
            if (!searchForContentLengthHeader || !"Content-Length".equals(header.getName())) continue;
            searchForContentLengthHeader = false;
            try {
                contentLength = Long.parseLong(header.getValue());
            }
            catch (NumberFormatException e) {
                if (!Global.DEBUG) continue;
                Utility.zlogD((String)LOGTAG, (String)e.getMessage());
            }
        }
        return (long)(firstLineBytes + headerLength) + contentLength;
    }

    private static long calcHttpRequestLength(HttpContext httpContext) {
        RequestWrapper wrapper = (RequestWrapper)httpContext.getAttribute("http.request");
        Header[] requestFromWrapperAllHeaders = wrapper.getAllHeaders();
        int respHeadersLength = 2;
        long contentLength = 0L;
        for (Header header : requestFromWrapperAllHeaders) {
            respHeadersLength += header.toString().length() + 2;
            if (!"Content-Length".equalsIgnoreCase(header.getName())) continue;
            contentLength = Long.parseLong(header.getValue());
        }
        return (long)(wrapper.getRequestLine().toString().length() + 2 + respHeadersLength) + contentLength;
    }

    void calcHttpMessageBytes(HttpResponse resp) {
        try {
            this.requestLength = UriReqStateParms.calcHttpRequestLength(this.httpContext);
            this.responseLength = UriReqStateParms.calcHttpResponseLength(resp);
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)e.getMessage(), (Throwable)e);
            }
            this.requestLength = -1L;
            this.responseLength = -1L;
        }
    }
}

