/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.ApacheUtil;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ConfigurationFactory;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CallbackCore;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.CbURIDesc;
import com.dynatrace.android.callback.CbWebReqTracker;
import com.dynatrace.android.callback.HttpClientCallback;
import com.dynatrace.android.callback.UriReqStateParms;
import com.dynatrace.android.callback.WebReqStateParms;
import java.util.WeakHashMap;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

final class HttpClientCallbackCore {
    private static final String LOGTAG = "caa-aHttpClientCallbackCore";
    private static final WeakHashMap<HttpRequest, CbWebReqTracker> httpReqs = new WeakHashMap();

    HttpClientCallbackCore() {
    }

    static CbWebReqTracker addHttpReq(HttpRequestBase httpReq) {
        return HttpClientCallbackCore.addHttpReq((HttpRequest)httpReq, HttpClientCallback.determineTarget((HttpUriRequest)httpReq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CbWebReqTracker addHttpReq(HttpRequest httpReq, HttpHost host) {
        if (httpReq == null) {
            return null;
        }
        if (!Dynatrace.getCaptureStatus() || !Session.currentSession().getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
            return null;
        }
        CbURIDesc uriDesc = CbURIDesc.createURIDesc(httpReq, host);
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("Add WR to %s", uriDesc.host));
        }
        if (!CallbackCore.lcInitialized.get()) {
            CallbackCore.init(null, (Configuration)ConfigurationFactory.getConfiguration());
        }
        if (!CallbackCore.configuration.webRequestTiming) {
            return null;
        }
        DTXAutoAction action = DTXAutoAction.getAutoAction();
        WebReqTag tag = HttpClientCallbackCore.generateWebReqTag(action, httpReq);
        if (tag == null) {
            return null;
        }
        CbWebReqTracker webReqState = new CbWebReqTracker(action, tag.getSession());
        WeakHashMap<HttpRequest, CbWebReqTracker> weakHashMap = httpReqs;
        synchronized (weakHashMap) {
            httpReqs.put(httpReq, webReqState);
        }
        webReqState.setWebReqTag(tag);
        return webReqState;
    }

    private static WebReqTag generateWebReqTag(DTXAutoAction action, HttpRequest httpReq) {
        WebReqTag dtTag;
        if (action != null && (dtTag = ApacheUtil.tagRequest((DTXActionImpl)action, httpReq)) != null) {
            return dtTag;
        }
        return ApacheUtil.tagRequest(httpReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateRequest(UriReqStateParms parm) {
        if (parm.getRequest() != null && CallbackCore.configuration.webRequestTiming) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("%s of %s of %s to %s", parm.state, parm.trackingMethod, parm.getRequest().getClass().getSimpleName(), parm.getRequestDesc()));
            }
        } else {
            return;
        }
        CbWebReqTracker webReqState = httpReqs.get(parm.getRequest());
        if (webReqState == null) {
            if (CbConstants.WrStates.PRE_EXEC == parm.state) {
                webReqState = HttpClientCallbackCore.addHttpReq(parm.getRequest(), parm.getExecHost());
            } else {
                return;
            }
        }
        if (webReqState == null) {
            return;
        }
        String tag = ApacheUtil.fetchWebReqTag(parm.getRequest());
        webReqState.checkForManualTag(tag);
        webReqState.procNewState((WebReqStateParms)parm);
        if (webReqState.canFinalize) {
            WeakHashMap<HttpRequest, CbWebReqTracker> weakHashMap = httpReqs;
            synchronized (weakHashMap) {
                httpReqs.remove(parm.getRequest());
            }
            webReqState.sendEvents((WebReqStateParms)parm);
        }
    }
}

