/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import android.app.Activity;
import android.app.Application;
import android.view.MenuItem;
import android.view.View;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.ConfigurationFactory;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.app.LcContext;
import com.dynatrace.android.callback.CallbackCore;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.ConnStateParms;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public final class Callback {
    private static final String LOGTAG = "caa-aCallback";
    private static Method sh_menuItem_getTitle = null;

    private Callback() {
    }

    public static void onCreate(Application application) {
        if (!CallbackCore.lcInitialized.get() && application != null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Initializing from application onCreate");
            }
            CallbackCore.init(application.getApplicationContext(), ConfigurationFactory.getConfiguration());
        }
    }

    public static void onCreate(Activity a) {
        if (!CallbackCore.lcInitialized.get() && a != null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Initializing from activity onCreate");
            }
            CallbackCore.init(a.getApplicationContext(), ConfigurationFactory.getConfiguration());
        }
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityCreate(a);
        }
    }

    public static void onPostCreate(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityPostCreate(a);
        }
    }

    public static void onStart(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityStart(a);
        }
    }

    public static void onRestart(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityRestart(a);
        }
    }

    public static void onResume(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityResume(a);
        }
    }

    public static void onPostResume(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityPostResume(a);
        }
    }

    public static void onPause(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityPause(a);
        }
    }

    public static void onStop(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityStop(a);
        }
    }

    public static void onDestroy(Activity a) {
        if (LcContext.getInstance().isLifecycleInEffect()) {
            LcContext.getInstance().getActivityLcCallbacks().onActivityDestroy(a);
        }
    }

    public static void newInstance(HttpURLConnection conn) {
        CallbackCore.addConnection(conn, false);
    }

    public static void openConnection(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            CallbackCore.addConnection((HttpURLConnection)conn, true);
        }
    }

    public static InputStream getInputStream(URLConnection conn) throws Exception {
        if (conn instanceof HttpURLConnection) {
            return Callback.getInputStream((HttpURLConnection)conn);
        }
        return conn.getInputStream();
    }

    public static InputStream getInputStream(HttpURLConnection conn) throws Exception {
        InputStream is = null;
        ConnStateParms parm = new ConnStateParms(conn, CbConstants.WrMethod.getInputStream, CbConstants.WrStates.PRE_EXEC, 0);
        try {
            Callback.updateConnection(parm);
            is = conn.getInputStream();
            Callback.getRespCodeFromConn(conn, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            Callback.updateConnection(parm);
        }
        catch (Exception e) {
            parm.reason = e.toString();
            throw e;
        }
        finally {
            Callback.getRespCodeFromConn(conn, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            Callback.updateConnection(parm);
        }
        return is;
    }

    public static OutputStream getOutputStream(URLConnection conn) throws Exception {
        if (conn instanceof HttpURLConnection) {
            return Callback.getOutputStream((HttpURLConnection)conn);
        }
        return conn.getOutputStream();
    }

    public static OutputStream getOutputStream(HttpURLConnection conn) throws Exception {
        OutputStream os = null;
        ConnStateParms parm = new ConnStateParms(conn, CbConstants.WrMethod.getOutputStream, CbConstants.WrStates.PRE_EXEC, 0);
        try {
            Callback.updateConnection(parm);
            os = conn.getOutputStream();
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            Callback.updateConnection(parm);
        }
        catch (Exception e) {
            parm.reason = e.toString();
            throw e;
        }
        finally {
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            Callback.updateConnection(parm);
        }
        return os;
    }

    public static int getResponseCode(HttpURLConnection conn) throws Exception {
        int rc = -1;
        ConnStateParms parm = new ConnStateParms(conn, CbConstants.WrMethod.getResponseCode, CbConstants.WrStates.PRE_EXEC, 0);
        try {
            Callback.updateConnection(parm);
            rc = conn.getResponseCode();
            Callback.getRespCodeFromConn(conn, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            Callback.updateConnection(parm);
        }
        catch (Exception e) {
            parm.reason = e.toString();
            throw e;
        }
        finally {
            parm.respCode = rc;
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            Callback.updateConnection(parm);
        }
        return rc;
    }

    private static int getRespCodeFromConn(HttpURLConnection conn, ConnStateParms wrsp) {
        int respCode;
        block2: {
            respCode = -1;
            try {
                respCode = conn.getResponseCode();
                wrsp.reason = conn.getResponseMessage();
            }
            catch (Exception e) {
                if (wrsp.reason != null) break block2;
                wrsp.reason = e.getMessage();
            }
        }
        wrsp.respCode = respCode;
        return respCode;
    }

    private static void updateConnection(ConnStateParms parm) {
        block2: {
            try {
                CallbackCore.updateConnection(parm);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogD((String)LOGTAG, (String)parm.toString(), (Throwable)e);
            }
        }
    }

    public static void onClick_ENTER(View view) {
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.Clicked, view);
    }

    public static void onClick_EXIT() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.Clicked);
    }

    public static void onItemClick_ENTER(View view, int pos) {
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.ItemClicked, view);
    }

    public static void onItemClick_EXIT() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.ItemClicked);
    }

    public static void onPageSelected_ENTER(int pos) {
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.PageSelected);
    }

    public static void onPageSelected_EXIT() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.PageSelected);
    }

    public static void onItemSelected_ENTER(View view, int pos) {
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.ItemSelected, view);
    }

    public static void onItemSelected_EXIT() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.ItemSelected);
    }

    public static void onMenuItemClick_ENTER(MenuItem menuItem) {
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.MenuItemClick, menuItem);
    }

    public static void onMenuItemClick_EXIT() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.MenuItemClick);
    }

    public static void onOptionsItemSelected_ENTER(MenuItem menuItem) {
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.OptionsItemSelected, menuItem);
    }

    public static void onOptionsItemSelected_EXIT() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.OptionsItemSelected);
    }

    public static void onRefresh_ENTER() {
        CallbackCore.onUserActionEnter(CallbackCore.ListenerActionType.SwipeToRefresh, CallbackCore.ListenerActionType.SwipeToRefresh.toString());
    }

    public static void onRefresh_EXIT() {
        CallbackCore.onUserActionExit(CallbackCore.ListenerActionType.SwipeToRefresh);
    }
}

