/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.common.connectivity.NetworkConnectivityCheckerImplKt;
import com.dynatrace.agent.common.connectivity.NetworkType;
import com.dynatrace.agent.events.enrichment.AttributeSupplierKt;
import com.dynatrace.agent.events.enrichment.BaseMetricsSupplier;
import com.dynatrace.agent.events.enrichment.EnrichmentAttribute;
import com.dynatrace.agent.events.enrichment.NetworkTypeExtensionsKt;
import com.dynatrace.agent.metrics.AppVersion;
import com.dynatrace.agent.storage.preference.MetricsDataModel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002J\u0012\u0010\f\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002J\u0012\u0010\r\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002J\u0012\u0010\u000e\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002J\u0012\u0010\u000f\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/agent/events/enrichment/StoredMetricsSupplier;", "Lcom/dynatrace/agent/events/enrichment/BaseMetricsSupplier;", "metricsDataModel", "Lcom/dynatrace/agent/storage/preference/MetricsDataModel;", "<init>", "(Lcom/dynatrace/agent/storage/preference/MetricsDataModel;)V", "supply", "", "Lcom/dynatrace/agent/events/enrichment/EnrichmentAttribute;", "addDeviceMetrics", "", "", "addOsMetrics", "addAppMetrics", "addGeoLocationMetrics", "addNetworkType", "com.dynatrace.agent_release"})
public final class StoredMetricsSupplier
extends BaseMetricsSupplier {
    @NotNull
    private final MetricsDataModel metricsDataModel;

    public StoredMetricsSupplier(@NotNull MetricsDataModel metricsDataModel) {
        Intrinsics.checkNotNullParameter((Object)metricsDataModel, (String)"metricsDataModel");
        this.metricsDataModel = metricsDataModel;
    }

    @Override
    @NotNull
    public List<EnrichmentAttribute> supply() {
        List list;
        List $this$supply_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.addDeviceMetrics($this$supply_u24lambda_u240);
        this.addOsMetrics($this$supply_u24lambda_u240);
        this.addAppMetrics($this$supply_u24lambda_u240);
        this.addGeoLocationMetrics($this$supply_u24lambda_u240);
        this.addNetworkType($this$supply_u24lambda_u240);
        return CollectionsKt.build((List)list);
    }

    private final void addDeviceMetrics(List<EnrichmentAttribute> $this$addDeviceMetrics) {
        String string;
        Integer screenWidth = this.validScreenDimensionOrNull$com_dynatrace_agent_release(this.metricsDataModel.getDeviceScreenWidth());
        Integer screenHeight = this.validScreenDimensionOrNull$com_dynatrace_agent_release(this.metricsDataModel.getDeviceScreenHeight());
        if (screenHeight != null && screenWidth != null) {
            AttributeSupplierKt.addAttribute($this$addDeviceMetrics, "device.screen.width", screenWidth);
            AttributeSupplierKt.addAttribute($this$addDeviceMetrics, "device.screen.height", screenHeight);
        }
        if ((string = this.metricsDataModel.getDeviceManufacturer()) == null) {
            string = "unknown";
        }
        AttributeSupplierKt.addAttribute($this$addDeviceMetrics, "device.manufacturer", string);
        String string2 = this.metricsDataModel.getDeviceModelIdentifier();
        if (string2 == null) {
            string2 = "unknown";
        }
        AttributeSupplierKt.addAttribute($this$addDeviceMetrics, "device.model.identifier", string2);
        AttributeSupplierKt.addAttribute($this$addDeviceMetrics, "device.is_rooted", this.metricsDataModel.getDeviceIsRooted());
        AttributeSupplierKt.addAttributeIfValueNotNull($this$addDeviceMetrics, "device.orientation", this.toDeviceOrientation$com_dynatrace_agent_release(this.metricsDataModel.getDeviceOrientation()));
        AttributeSupplierKt.addAttributeIfValueNotNull($this$addDeviceMetrics, "device.battery.level", this.validBatteryLevelOrNull$com_dynatrace_agent_release(this.metricsDataModel.getDeviceBatteryLevel()));
    }

    private final void addOsMetrics(List<EnrichmentAttribute> $this$addOsMetrics) {
        AttributeSupplierKt.addAttribute($this$addOsMetrics, "os.name", this.metricsDataModel.getOsName());
        String string = this.metricsDataModel.getOsVersion();
        if (string == null) {
            string = "unknown";
        }
        AttributeSupplierKt.addAttribute($this$addOsMetrics, "os.version", string);
    }

    private final void addAppMetrics(List<EnrichmentAttribute> $this$addAppMetrics) {
        AppVersion appVersion = this.metricsDataModel.getAppVersion();
        if (appVersion != null) {
            AppVersion appVersion2;
            AppVersion $this$addAppMetrics_u24lambda_u241 = appVersion2 = appVersion;
            boolean bl = false;
            AttributeSupplierKt.addAttribute($this$addAppMetrics, "app.version", String.valueOf($this$addAppMetrics_u24lambda_u241.getVersionCode()));
            AttributeSupplierKt.addAttribute($this$addAppMetrics, "app.short_version", $this$addAppMetrics_u24lambda_u241.getVersionName());
        }
        AttributeSupplierKt.addAttribute($this$addAppMetrics, "app.bundle", this.metricsDataModel.getBundle());
    }

    private final void addGeoLocationMetrics(List<EnrichmentAttribute> $this$addGeoLocationMetrics) {
        Double latitude = this.metricsDataModel.getLocationLatitude();
        Double longitude = this.metricsDataModel.getLocationLongitude();
        if (latitude != null && longitude != null) {
            AttributeSupplierKt.addAttribute($this$addGeoLocationMetrics, "geo.location.latitude", new BigDecimal(latitude).setScale(2, RoundingMode.HALF_UP).doubleValue());
            AttributeSupplierKt.addAttribute($this$addGeoLocationMetrics, "geo.location.longitude", new BigDecimal(longitude).setScale(2, RoundingMode.HALF_UP).doubleValue());
        }
    }

    private final void addNetworkType(List<EnrichmentAttribute> $this$addNetworkType) {
        NetworkType networkType;
        NetworkType networkType2 = networkType = NetworkConnectivityCheckerImplKt.toNetworkTypeOrNull(this.metricsDataModel.getNetworkType());
        String mapped = networkType2 != null ? NetworkTypeExtensionsKt.getStringRepresentation(networkType2) : null;
        AttributeSupplierKt.addAttributeIfValueNotNull($this$addNetworkType, "network.connection.type", mapped);
    }
}

