/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.dynatrace.agent.common.connectivity.LocalBuild;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J!\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u0013H\u0002J\r\u0010 \u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b!J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0000\u00a2\u0006\u0002\b#J\u001e\u0010$\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dJ!\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010(\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b)J\u0012\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/dynatrace/agent/util/RootDetector;", "", "()V", "BINARY_BUSYBOX", "", "BINARY_MAGISK", "BINARY_SU", "DEVICE_PROPERTY_FORMAT", "LOG_TAG", "RO_DEBUGGABLE", "RO_SECURE", "TEST_KEYS", "knownDangerousAppsPackages", "", "knownRootAppsPackages", "knownRootCloakingPackages", "pathsThatShouldNotBeWritable", "suPaths", "checkBinary", "", "directories", "fileName", "checkForDangerousProps", "properties", "", "checkForDangerousProps$com_dynatrace_agent_release", "checkForRWPaths", "checkPotentialRootApps", "context", "Landroid/content/Context;", "checkPotentialRootApps$com_dynatrace_agent_release", "checkSuExists", "checkTestKeys", "checkTestKeys$com_dynatrace_agent_release", "determineBinaryPaths", "determineBinaryPaths$com_dynatrace_agent_release", "isAnyPackageFromListInstalled", "packages", "isDeviceRooted", "parseDeviceProperties", "deviceProperties", "parseDeviceProperties$com_dynatrace_agent_release", "readDeviceProperties", "command", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nRootDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootDetector.kt\ncom/dynatrace/agent/util/RootDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,388:1\n766#2:389\n857#2,2:390\n1747#2,3:400\n1747#2,2:403\n766#2:405\n857#2,2:406\n1747#2,2:408\n1747#2,3:410\n1749#2:413\n1749#2:414\n187#3,3:392\n689#4:395\n722#4,4:396\n*S KotlinDebug\n*F\n+ 1 RootDetector.kt\ncom/dynatrace/agent/util/RootDetector\n*L\n144#1:389\n144#1:390,2\n288#1:400,3\n369#1:403,2\n370#1:405\n370#1:406,2\n381#1:408,2\n383#1:410,3\n381#1:413\n369#1:414\n238#1:392,3\n269#1:395\n269#1:396,4\n*E\n"})
public final class RootDetector {
    @NotNull
    public static final RootDetector INSTANCE = new RootDetector();
    @NotNull
    private static final String TEST_KEYS = "test-keys";
    @NotNull
    private static final String BINARY_SU = "su";
    @NotNull
    private static final String BINARY_BUSYBOX = "busybox";
    @NotNull
    private static final String BINARY_MAGISK = "magisk";
    @NotNull
    private static final String RO_DEBUGGABLE = "ro.debuggable";
    @NotNull
    private static final String RO_SECURE = "ro.secure";
    @NotNull
    private static final String DEVICE_PROPERTY_FORMAT = "\\[(.*?)]:\\s*\\[(.*?)]";
    @NotNull
    private static final String LOG_TAG = Global.LOG_PREFIX + "RootDetector";
    @NotNull
    private static final List<String> knownRootAppsPackages;
    @NotNull
    private static final List<String> knownDangerousAppsPackages;
    @NotNull
    private static final List<String> knownRootCloakingPackages;
    @NotNull
    private static final List<String> suPaths;
    @NotNull
    private static final List<String> pathsThatShouldNotBeWritable;

    private RootDetector() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> determineBinaryPaths$com_dynatrace_agent_release() {
        void $this$filterTo$iv$iv;
        List paths = CollectionsKt.toMutableList((Collection)suPaths);
        String sysPaths = System.getenv("PATH");
        if (sysPaths == null || ((CharSequence)sysPaths).length() == 0) {
            return paths;
        }
        String[] stringArray = new String[]{":"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)sysPaths, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            String path;
            String internalPath = path = (String)iterator.next();
            if (!StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                internalPath = path + '/';
            }
            if (paths.contains(internalPath)) continue;
            paths.add(internalPath);
        }
        return paths;
    }

    public final boolean isDeviceRooted(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.checkTestKeys$com_dynatrace_agent_release() || this.checkPotentialRootApps$com_dynatrace_agent_release(context)) {
            return true;
        }
        String deviceProperties = this.readDeviceProperties("getprop");
        if (deviceProperties != null && this.checkForDangerousProps$com_dynatrace_agent_release(this.parseDeviceProperties$com_dynatrace_agent_release(deviceProperties))) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "suspicious properties detected");
            }
            return true;
        }
        List<String> directories = this.determineBinaryPaths$com_dynatrace_agent_release();
        if (this.checkBinary(directories, BINARY_SU) || this.checkBinary(directories, BINARY_BUSYBOX) || this.checkBinary(directories, BINARY_MAGISK)) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "suspicious file detected");
            }
            return true;
        }
        if (this.checkSuExists()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "su command detected");
            }
            return true;
        }
        if (this.checkForRWPaths()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "file permissions for system directories modified");
            }
            return true;
        }
        return false;
    }

    public final boolean checkTestKeys$com_dynatrace_agent_release() {
        boolean isTestKeys;
        String tags;
        String string = tags = LocalBuild.INSTANCE.getTestTags();
        boolean bl = isTestKeys = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)TEST_KEYS, (boolean)false, (int)2, null) : false;
        if (isTestKeys && Global.DEBUG) {
            Utility.zlogD(LOG_TAG, "test-keys detected");
        }
        return isTestKeys;
    }

    public final boolean checkForDangerousProps$com_dynatrace_agent_release(@NotNull Map<String, String> properties) {
        boolean bl;
        block3: {
            Map dangerousProps;
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)RO_DEBUGGABLE, (Object)"1"), TuplesKt.to((Object)RO_SECURE, (Object)"0")};
            Map $this$any$iv = dangerousProps = MapsKt.mapOf((Pair[])pairArray);
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(entry.getValue(), (Object)properties.get(entry.getKey()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String readDeviceProperties(String command) {
        String string;
        try {
            InputStream inputStream = Runtime.getRuntime().exec(command).getInputStream();
            if (inputStream == null) {
                return null;
            }
            InputStream inputStream2 = inputStream;
            string = new Scanner(inputStream2).useDelimiter("\\A").next();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> parseDeviceProperties$com_dynatrace_agent_release(@NotNull String deviceProperties) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)deviceProperties, (String)"deviceProperties");
        Sequence $this$associateBy$iv = Regex.findAll$default((Regex)new Regex(DEVICE_PROPERTY_FORMAT), (CharSequence)deviceProperties, (int)0, (int)2, null);
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            MatchResult matchResult = (MatchResult)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            MatchResult it = (MatchResult)element$iv$iv;
            String string = (String)it.getGroupValues().get(1);
            boolean bl2 = false;
            String string2 = (String)it.getGroupValues().get(2);
            map2.put(string, string2);
        }
        return destination$iv$iv;
    }

    public final boolean checkPotentialRootApps$com_dynatrace_agent_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isAnyPackageFromListInstalled(knownRootAppsPackages, context) || this.isAnyPackageFromListInstalled(knownRootCloakingPackages, context) || this.isAnyPackageFromListInstalled(knownDangerousAppsPackages, context);
    }

    private final boolean isAnyPackageFromListInstalled(List<String> packages, Context context) {
        boolean bl;
        block6: {
            PackageManager pm = context.getPackageManager();
            Iterable $this$any$iv = packages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    String packageName = (String)element$iv;
                    boolean bl3 = false;
                    try {
                        pm.getPackageInfo(packageName, 0);
                        if (Global.DEBUG) {
                            Utility.zlogD(LOG_TAG, "detected package: " + packageName);
                        }
                        bl2 = true;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkSuExists() {
        Process process2 = null;
        try {
            String[] stringArray = new String[]{"which", BINARY_SU};
            Process process3 = Runtime.getRuntime().exec(stringArray);
            Intrinsics.checkNotNull((Object)process3);
            process2 = process3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process2.getInputStream()));
            boolean bl = bufferedReader.readLine() != null;
            return bl;
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            block5: {
                Process process4 = process2;
                if (process4 == null) break block5;
                process4.destroy();
            }
        }
    }

    private final boolean checkBinary(List<String> directories, String fileName) {
        for (String path : directories) {
            File file = new File(path, fileName);
            if (!file.exists()) continue;
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "file detected: " + file);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkForRWPaths() {
        boolean bl;
        String string = this.readDeviceProperties("mount");
        if (string == null) {
            return false;
        }
        String mount = string;
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)mount, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        int sdkVersion = Build.VERSION.SDK_INT;
        int minSize = sdkVersion > 23 ? 6 : 4;
        Iterable $this$any$iv = lines;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            void $this$filterTo$iv$iv;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String line = (String)element$iv;
            boolean bl2 = false;
            String[] stringArray2 = new String[]{" "};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)line, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = ((CharSequence)it).length() > 0;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List args = (List)destination$iv$iv;
            if (args.size() < minSize) {
                bl = false;
                continue;
            }
            stringArray2 = sdkVersion > 23 ? TuplesKt.to(args.get(2), (Object)StringsKt.removeSurrounding((String)((String)args.get(5)), (CharSequence)"(", (CharSequence)")")) : TuplesKt.to(args.get(1), args.get(3));
            String mountPoint = (String)stringArray2.component1();
            String mountOptions = (String)stringArray2.component2();
            Iterable $this$any$iv2 = pathsThatShouldNotBeWritable;
            boolean $i$f$any2 = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                bl = false;
                continue;
            }
            for (Object element$iv2 : $this$any$iv2) {
                String path = (String)element$iv2;
                boolean bl5 = false;
                if (StringsKt.equals((String)path, (String)mountPoint, (boolean)true)) {
                    boolean bl6;
                    String[] stringArray3 = new String[]{","};
                    Iterable $this$any$iv3 = StringsKt.split$default((CharSequence)mountOptions, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$any3 = false;
                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv3) {
                            String it = (String)element$iv3;
                            boolean bl7 = false;
                            if (!StringsKt.equals((String)it, (String)"rw", (boolean)true)) continue;
                            return true;
                        }
                        bl6 = false;
                    }
                    if (bl6) {
                        return true;
                    }
                }
                boolean bl8 = false;
                if (!bl8) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    static {
        Object[] objectArray = new String[]{"com.noshufou.android.su", "com.noshufou.android.su.elite", "eu.chainfire.supersu", "com.koushikdutta.superuser", "com.thirdparty.superuser", "com.yellowes.su", "com.topjohnwu.magisk", "com.kingroot.kinguser", "com.kingo.root", "com.smedialink.oneclickroot", "com.zhiqupk.root.global", "com.alephzain.framaroot"};
        knownRootAppsPackages = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"com.koushikdutta.rommanager", "com.koushikdutta.rommanager.license", "com.dimonvideo.luckypatcher", "com.chelpus.lackypatch", "com.ramdroid.appquarantine", "com.ramdroid.appquarantinepro", "com.android.vending.billing.InAppBillingService.COIN", "com.android.vending.billing.InAppBillingService.LUCK", "com.chelpus.luckypatcher", "com.blackmartalpha", "org.blackmart.market", "com.allinone.free", "com.repodroid.app", "org.creeplays.hack", "com.baseappfull.fwd", "com.zmapp", "com.dv.marketmod.installer", "org.mobilism.android", "com.android.wp.net.log", "com.android.camera.update", "cc.madkite.freedom", "com.solohsu.android.edxp.manager", "org.meowcat.edxposed.manager", "com.xmodgame", "com.cih.game_cih", "com.charles.lpoqasert", "catch_.me_.if_.you_.can_"};
        knownDangerousAppsPackages = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"com.devadvance.rootcloak", "com.devadvance.rootcloakplus", "de.robv.android.xposed.installer", "com.saurik.substrate", "com.zachspong.temprootremovejb", "com.amphoras.hidemyroot", "com.amphoras.hidemyrootadfree", "com.formyhm.hiderootPremium", "com.formyhm.hideroot"};
        knownRootCloakingPackages = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"/data/local/", "/data/local/bin/", "/data/local/xbin/", "/sbin/", "/su/bin/", "/system/bin/", "/system/bin/.ext/", "/system/bin/failsafe/", "/system/sd/xbin/", "/system/usr/we-need-root/", "/system/xbin/", "/cache/", "/data/", "/dev/"};
        suPaths = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"/system", "/system/bin", "/system/sbin", "/system/xbin", "/vendor/bin", "/sbin", "/etc"};
        pathsThatShouldNotBeWritable = CollectionsKt.listOf((Object[])objectArray);
    }
}

