/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.lifecycle.util;

import com.dynatrace.agent.lifecycle.model.AppStartupPhase;
import com.dynatrace.agent.lifecycle.model.AppStartupType;
import com.dynatrace.android.agent.util.Utility;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/agent/lifecycle/util/AppStartupLogger;", "", "()V", "logApplicationStartup", "", "startupType", "Lcom/dynatrace/agent/lifecycle/model/AppStartupType;", "beginTime", "", "endTime", "logApplicationStartupBegin", "logApplicationStartupCancel", "logPhase", "startupPhase", "Lcom/dynatrace/agent/lifecycle/model/AppStartupPhase;", "startTime", "toDateFormat", "", "com.dynatrace.agent_release"})
public final class AppStartupLogger {
    public final void logApplicationStartupBegin(@NotNull AppStartupType startupType, long beginTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)startupType), (String)"startupType");
        Utility.devLog("dtxEventGeneration", "App startup type " + startupType.name() + " begin at " + this.toDateFormat(beginTime));
    }

    public final void logApplicationStartup(@NotNull AppStartupType startupType, long beginTime, long endTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)startupType), (String)"startupType");
        Utility.devLog("dtxEventGeneration", "App startup type " + startupType.name() + " duration: " + (endTime - beginTime) + " ms");
    }

    public final void logApplicationStartupCancel(@NotNull AppStartupType startupType) {
        Intrinsics.checkNotNullParameter((Object)((Object)startupType), (String)"startupType");
        Utility.devLog("dtxEventGeneration", "App startup type " + startupType.name() + " was not finished");
    }

    public final void logPhase(@NotNull AppStartupType startupType, @NotNull AppStartupPhase startupPhase, long startTime, long endTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)startupType), (String)"startupType");
        Intrinsics.checkNotNullParameter((Object)((Object)startupPhase), (String)"startupPhase");
        Utility.devLog("dtxEventGeneration", "App startup type " + startupType.name() + " phase " + startupPhase.name() + " [" + this.toDateFormat(startTime) + "] -> [" + this.toDateFormat(endTime) + ']');
    }

    private final String toDateFormat(long $this$toDateFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS", Locale.getDefault());
        Date date = new Date();
        date.setTime($this$toDateFormat);
        String string = dateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

