/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.lifecycle;

import android.app.Application;
import android.os.Build;
import com.dynatrace.agent.lifecycle.AppStartupManager;
import com.dynatrace.agent.lifecycle.VisibilityManager;
import com.dynatrace.agent.lifecycle.callback.ActivityLifecycleListener;
import com.dynatrace.agent.lifecycle.callback.ActivityLifecycleListenerLegacy;
import com.dynatrace.agent.lifecycle.model.AppStartupPhase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/agent/lifecycle/OneAgentLifecycleManager;", "", "appStartupManager", "Lcom/dynatrace/agent/lifecycle/AppStartupManager;", "visibilityManager", "Lcom/dynatrace/agent/lifecycle/VisibilityManager;", "application", "Landroid/app/Application;", "(Lcom/dynatrace/agent/lifecycle/AppStartupManager;Lcom/dynatrace/agent/lifecycle/VisibilityManager;Landroid/app/Application;)V", "activityLifecycleListener", "Landroid/app/Application$ActivityLifecycleCallbacks;", "isAppStarted", "", "onAgentShutdown", "", "onAppStart", "com.dynatrace.agent_release"})
public final class OneAgentLifecycleManager {
    @NotNull
    private final AppStartupManager appStartupManager;
    @NotNull
    private final Application application;
    private boolean isAppStarted;
    @NotNull
    private final Application.ActivityLifecycleCallbacks activityLifecycleListener;

    public OneAgentLifecycleManager(@NotNull AppStartupManager appStartupManager2, @NotNull VisibilityManager visibilityManager, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)appStartupManager2, (String)"appStartupManager");
        Intrinsics.checkNotNullParameter((Object)visibilityManager, (String)"visibilityManager");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.appStartupManager = appStartupManager2;
        this.application = application;
        this.activityLifecycleListener = Build.VERSION.SDK_INT >= 29 ? (Application.ActivityLifecycleCallbacks)new ActivityLifecycleListener(this.appStartupManager, visibilityManager) : (Application.ActivityLifecycleCallbacks)new ActivityLifecycleListenerLegacy(this.appStartupManager, visibilityManager);
    }

    public final void onAppStart() {
        if (!this.isAppStarted) {
            this.isAppStarted = true;
            this.appStartupManager.onStartupPhase(AppStartupPhase.APPLICATION_CREATE);
            this.application.registerActivityLifecycleCallbacks(this.activityLifecycleListener);
        }
    }

    public final void onAgentShutdown() {
        this.isAppStarted = false;
        this.application.unregisterActivityLifecycleCallbacks(this.activityLifecycleListener);
    }
}

