/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.exitreason.convertor;

import android.app.ApplicationExitInfo;
import com.dynatrace.agent.exitreason.convertor.JsonExitReasonEventConvertor;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/dynatrace/agent/exitreason/convertor/JsonExitReasonEventConvertor;", "", "()V", "convertANR", "Lorg/json/JSONObject;", "applicationExitInfo", "Landroid/app/ApplicationExitInfo;", "convertNativeCrash", "extractThreadsInfo", "", "input", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nJsonExitReasonEventConvertor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonExitReasonEventConvertor.kt\ncom/dynatrace/agent/exitreason/convertor/JsonExitReasonEventConvertor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class JsonExitReasonEventConvertor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JSONObject convertANR(@NotNull ApplicationExitInfo applicationExitInfo) {
        JSONObject jSONObject;
        block10: {
            Intrinsics.checkNotNullParameter((Object)applicationExitInfo, (String)"applicationExitInfo");
            Utility.devLog("dtxCrashTracker", "anr " + applicationExitInfo);
            try {
                InputStream inputStream;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("characteristics.has_error", true);
                jsonObject.put("characteristics.has_anr", true);
                jsonObject.put("error.is_fatal", true);
                if (applicationExitInfo.getDescription() != null) {
                    jsonObject.put("exception.message", (Object)applicationExitInfo.getDescription());
                }
                if ((inputStream = applicationExitInfo.getTraceInputStream()) == null) break block10;
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object inputText = object2;
                String threadsInfo = this.extractThreadsInfo((String)inputText);
                if (((CharSequence)threadsInfo).length() > 0) {
                    jsonObject.put("exception.stack_trace", (Object)threadsInfo);
                } else {
                    Utility.devLog("dtxCrashTracker", "anr threads don't match pattern");
                }
            }
            catch (JSONException e) {
                Utility.devLog("dtxCrashTracker", "anr event cannot be created");
                jSONObject = null;
            }
        }
        return jSONObject;
    }

    @Nullable
    public final JSONObject convertNativeCrash(@NotNull ApplicationExitInfo applicationExitInfo) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)applicationExitInfo, (String)"applicationExitInfo");
        Utility.devLog("dtxCrashTracker", "native crash " + applicationExitInfo);
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("characteristics.has_error", true);
            jsonObject.put("characteristics.has_crash", true);
            jsonObject.put("error.is_fatal", true);
        }
        catch (JSONException e) {
            Utility.devLog("dtxCrashTracker", "native crash event cannot be created");
            jSONObject = null;
        }
        return jSONObject;
    }

    private final String extractThreadsInfo(String input) {
        Regex regex = new Regex("(?ms)^\".*?(?=\\n\\s*(?:DumpLatency|\\s*$))");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)input, (int)0, (int)2, null), (Function1)extractThreadsInfo.1.INSTANCE), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
    }
}

