/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.error;

import com.dynatrace.android.agent.util.Utility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorEvent {
    private static final int MAX_SIZE_OF_STACK_TRACE_IN_BYTES = 224000;
    private static final int MAX_SIZE_OF_EXCEPTION_MESSAGE_IN_BYTES = 24000;

    public static JSONObject crashEvent(Throwable throwable) {
        try {
            JSONObject jsonObject = ErrorEvent.generateBaseErrorEvent(throwable);
            jsonObject.put("characteristics.has_crash", true);
            jsonObject.put("error.is_fatal", true);
            Utility.devLog("dtxEventGeneration", "crash event: " + jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog("dtxEventGeneration", "crash event can't be generated");
            return new JSONObject();
        }
    }

    public static JSONObject errorExceptionEvent(Throwable throwable, String name) {
        try {
            JSONObject jsonObject = ErrorEvent.generateBaseErrorEvent(throwable);
            jsonObject.put("name", (Object)name);
            jsonObject.put("characteristics.has_exception", true);
            Utility.devLog("dtxEventGeneration", "error event: " + jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog("dtxEventGeneration", "error event can't be generated");
            return new JSONObject();
        }
    }

    public static JSONObject generateErrorEvent(String name, int errorCode) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)name);
            jsonObject.put("characteristics.has_error", true);
            jsonObject.put("error.code", errorCode);
            Utility.devLog("dtxEventGeneration", "error code event: " + jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog("dtxEventGeneration", "error code event can't be generated");
            return new JSONObject();
        }
    }

    private static JSONObject generateBaseErrorEvent(Throwable throwable) {
        ExceptionInfo exceptionInfo = ErrorEvent.parseThrowable(throwable, 224000, 24000);
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("characteristics.has_error", true);
            if (exceptionInfo.getMessage() != null) {
                jsonObject.put("exception.message", (Object)exceptionInfo.getMessage());
            }
            if (exceptionInfo.getClassName() != null) {
                jsonObject.put("exception.type", (Object)exceptionInfo.getClassName());
            }
            if (exceptionInfo.getStacktrace() != null) {
                jsonObject.put("exception.stack_trace", (Object)exceptionInfo.getStacktrace());
            }
            return jsonObject;
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    public static ExceptionInfo parseThrowable(Throwable throwable, int maxStackTraceSizeInBytes, int maxMessageSizeInBytes) {
        StringWriter stacktraceWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stacktraceWriter));
        String stackTrace = stacktraceWriter.toString();
        String sanitizedMessage = null;
        if (throwable.getMessage() != null) {
            sanitizedMessage = ErrorEvent.sanitizeThrowableMessage(throwable.getMessage(), maxMessageSizeInBytes);
        }
        String sanitizedStackTrace = null;
        if (throwable.getStackTrace().length > 0) {
            sanitizedStackTrace = ErrorEvent.sanitizeStackTrace(stackTrace, maxStackTraceSizeInBytes);
        }
        return new ExceptionInfo(throwable.getClass().getName(), sanitizedMessage, sanitizedStackTrace);
    }

    private static String sanitizeThrowableMessage(String message, int maxSizeInBytes) {
        byte[] messageBytes = message.getBytes();
        if (messageBytes.length <= maxSizeInBytes) {
            return message;
        }
        return new String(messageBytes, 0, maxSizeInBytes) + "...";
    }

    private static String sanitizeStackTrace(String stackTrace, int maxSizeInBytes) {
        byte[] byteArray = stackTrace.getBytes();
        if (byteArray.length > maxSizeInBytes) {
            return ErrorEvent.truncateAtLineBoundary(stackTrace, maxSizeInBytes);
        }
        return stackTrace;
    }

    private static String truncateAtLineBoundary(String str, int maxSizeInBytes) {
        int currentSize = 0;
        StringBuilder result = new StringBuilder();
        for (String line : str.split("\n")) {
            int lineSize = line.getBytes(StandardCharsets.UTF_8).length + 1;
            if (currentSize + lineSize > maxSizeInBytes) {
                result.append("...");
                return result.toString();
            }
            result.append(line).append("\n");
            currentSize += lineSize;
        }
        result.append("...");
        return result.toString();
    }

    public static class ExceptionInfo {
        private String className;
        private String message;
        private String stacktrace;

        public ExceptionInfo(String className, String message, String stacktrace) {
            this.className = className;
            this.message = message;
            this.stacktrace = stacktrace;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }
}

