/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication.network.datasource;

import com.dynatrace.agent.common.connectivity.NetworkConnectivityChecker;
import com.dynatrace.agent.communication.LocalServerData;
import com.dynatrace.agent.communication.api.ServerDataUpdate;
import com.dynatrace.agent.communication.network.datasource.ConfigRequest;
import com.dynatrace.agent.communication.network.datasource.DataRequest;
import com.dynatrace.agent.communication.network.datasource.NetworkDataSource;
import com.dynatrace.agent.communication.network.datasource.NetworkDataSourceImplKt;
import com.dynatrace.agent.communication.network.request.ConfigRequestFactory;
import com.dynatrace.agent.communication.network.request.DataRequestFactory;
import com.dynatrace.agent.communication.network.response.ConfigurationsParser;
import com.dynatrace.agent.communication.network.response.ResponseResult;
import com.dynatrace.agent.communication.network.response.ResponseResultKt;
import com.dynatrace.agent.storage.db.EndPointInfo;
import com.dynatrace.android.agent.util.Utility;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/dynatrace/agent/communication/network/datasource/NetworkDataSourceImpl;", "Lcom/dynatrace/agent/communication/network/datasource/NetworkDataSource;", "client", "Lokhttp3/Call$Factory;", "configRequestFactory", "Lcom/dynatrace/agent/communication/network/request/ConfigRequestFactory;", "dataRequestFactory", "Lcom/dynatrace/agent/communication/network/request/DataRequestFactory;", "configurationsParser", "Lcom/dynatrace/agent/communication/network/response/ConfigurationsParser;", "connectivityChecker", "Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityChecker;", "(Lokhttp3/Call$Factory;Lcom/dynatrace/agent/communication/network/request/ConfigRequestFactory;Lcom/dynatrace/agent/communication/network/request/DataRequestFactory;Lcom/dynatrace/agent/communication/network/response/ConfigurationsParser;Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityChecker;)V", "noInternetConnectionRetryReason", "", "executeConfigRequest", "Lcom/dynatrace/agent/communication/network/response/ResponseResult;", "request", "Lcom/dynatrace/agent/communication/network/datasource/ConfigRequest;", "(Lcom/dynatrace/agent/communication/network/datasource/ConfigRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeDataRequest", "Lcom/dynatrace/agent/communication/network/datasource/DataRequest;", "(Lcom/dynatrace/agent/communication/network/datasource/DataRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleResponse", "response", "Lokhttp3/Response;", "currentServerData", "Lcom/dynatrace/agent/communication/LocalServerData;", "endPointInfo", "Lcom/dynatrace/agent/storage/db/EndPointInfo;", "com.dynatrace.agent_release"})
public final class NetworkDataSourceImpl
implements NetworkDataSource {
    @NotNull
    private final Call.Factory client;
    @NotNull
    private final ConfigRequestFactory configRequestFactory;
    @NotNull
    private final DataRequestFactory dataRequestFactory;
    @NotNull
    private final ConfigurationsParser configurationsParser;
    @NotNull
    private final NetworkConnectivityChecker connectivityChecker;
    @NotNull
    private final String noInternetConnectionRetryReason;

    public NetworkDataSourceImpl(@NotNull Call.Factory client, @NotNull ConfigRequestFactory configRequestFactory, @NotNull DataRequestFactory dataRequestFactory, @NotNull ConfigurationsParser configurationsParser, @NotNull NetworkConnectivityChecker connectivityChecker) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)configRequestFactory, (String)"configRequestFactory");
        Intrinsics.checkNotNullParameter((Object)dataRequestFactory, (String)"dataRequestFactory");
        Intrinsics.checkNotNullParameter((Object)configurationsParser, (String)"configurationsParser");
        Intrinsics.checkNotNullParameter((Object)connectivityChecker, (String)"connectivityChecker");
        this.client = client;
        this.configRequestFactory = configRequestFactory;
        this.dataRequestFactory = dataRequestFactory;
        this.configurationsParser = configurationsParser;
        this.connectivityChecker = connectivityChecker;
        this.noInternetConnectionRetryReason = "No internet connection";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object executeDataRequest(@NotNull DataRequest request, @NotNull Continuation<? super ResponseResult> $completion) {
        ResponseResult responseResult;
        try {
            ResponseResult responseResult2;
            if (this.connectivityChecker.isNetworkConnected()) {
                void okhttpRequest;
                Request request2;
                Request request3 = request2 = this.dataRequestFactory.createRequest(request);
                Call.Factory factory = this.client;
                boolean bl = false;
                Utility.devLog("dtxCommunication", "data request: " + okhttpRequest);
                Utility.devLog("dtxCommunication", "data request body: " + request.getBody());
                Response response = factory.newCall(request2).execute();
                responseResult2 = this.handleResponse(response, request.getServerData(), request.getEndPointInfo());
            } else {
                Utility.devLog("dtxCommunication", "data request failed: no connectivity");
                responseResult2 = new ResponseResult.Retry(this.noInternetConnectionRetryReason, null);
            }
            responseResult = responseResult2;
        }
        catch (Exception exception) {
            Utility.devLog("dtxCommunication", "data request failed with exception:", exception);
            responseResult = ResponseResult.UnexpectedError.INSTANCE;
        }
        return responseResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object executeConfigRequest(@NotNull ConfigRequest request, @NotNull Continuation<? super ResponseResult> $completion) {
        ResponseResult responseResult;
        try {
            ResponseResult responseResult2;
            if (this.connectivityChecker.isNetworkConnected()) {
                void okhttpRequest;
                Request request2;
                Request request3 = request2 = this.configRequestFactory.createRequest(request);
                Call.Factory factory = this.client;
                boolean bl = false;
                Utility.devLog("dtxCommunication", "config request: " + okhttpRequest);
                Response response = factory.newCall(request2).execute();
                responseResult2 = this.handleResponse(response, request.getServerData(), request.getEndPointInfo());
            } else {
                Utility.devLog("dtxCommunication", "config request failed: no connectivity");
                responseResult2 = new ResponseResult.Retry(this.noInternetConnectionRetryReason, null);
            }
            responseResult = responseResult2;
        }
        catch (Exception exception) {
            Utility.devLog("dtxCommunication", "config request failed with exception:", exception);
            responseResult = ResponseResult.UnexpectedError.INSTANCE;
        }
        return responseResult;
    }

    private final ResponseResult handleResponse(Response response, LocalServerData currentServerData, EndPointInfo endPointInfo) {
        ResponseResult responseResult;
        if (ResponseResultKt.isTooManyRequest(response)) {
            Long retryValue;
            String string = response.headers().get("Retry-After");
            Long l = retryValue = string != null ? StringsKt.toLongOrNull((String)string) : null;
            long delay = retryValue != null ? DurationKt.toDuration((long)retryValue, (DurationUnit)DurationUnit.SECONDS) : NetworkDataSourceImplKt.access$getTOO_MANY_REQUESTS_DEFAULT_DELAY$p();
            Utility.devLog("dtxCommunication", "erroneous response: too many requests; retry-after: " + retryValue);
            responseResult = new ResponseResult.TooManyRequests(delay, null);
        } else if (ResponseResultKt.isUnexpectedError(response)) {
            ResponseBody responseBody = response.body();
            String body = responseBody != null ? responseBody.string() : null;
            Utility.devLog("dtxCommunication", "erroneous response: unexpected response code: " + response.code() + "; body: " + body);
            responseResult = ResponseResult.UnexpectedError.INSTANCE;
        } else {
            String body;
            ResponseBody responseBody = response.body();
            String string = body = responseBody != null ? responseBody.string() : null;
            if (body == null) {
                Utility.devLog("dtxCommunication", "erroneous response: no body; response code: " + response.code());
                return ResponseResult.UnexpectedError.INSTANCE;
            }
            ServerDataUpdate serverDataUpdate = this.configurationsParser.parse$com_dynatrace_agent_release(body, currentServerData, endPointInfo);
            if (serverDataUpdate == null) {
                Utility.devLog("dtxCommunication", "erroneous config received: parsing error; response code: " + response.code() + "; body: " + body);
                responseResult = ResponseResult.UnexpectedError.INSTANCE;
            } else if (ResponseResultKt.isSuccess(response)) {
                Utility.devLog("dtxCommunication", "successful response: " + body);
                responseResult = new ResponseResult.Success(serverDataUpdate);
            } else {
                Utility.devLog("dtxCommunication", "retrying due to erroneous response code: " + response.code() + "; body: " + body);
                responseResult = new ResponseResult.Retry(String.valueOf(response.code()), serverDataUpdate);
            }
        }
        return responseResult;
    }
}

