/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication;

import com.dynatrace.agent.communication.network.model.RetryInfo;
import com.dynatrace.agent.storage.db.EndPointInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0013\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0086\u0002J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/agent/communication/RetryManager;", "", "()V", "retryStateByEndpoint", "", "Lcom/dynatrace/agent/storage/db/EndPointInfo;", "Lcom/dynatrace/agent/communication/network/model/RetryInfo;", "clearRetryState", "", "endpoint", "get", "getIncrementedRetryInfo", "reason", "", "com.dynatrace.agent_release"})
public final class RetryManager {
    @NotNull
    private final Map<EndPointInfo, RetryInfo> retryStateByEndpoint = new LinkedHashMap();

    @NotNull
    public final RetryInfo getIncrementedRetryInfo(@NotNull EndPointInfo endpoint, @NotNull String reason) {
        RetryInfo retryInfo;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        RetryInfo retryInfo2 = this.retryStateByEndpoint.get(endpoint);
        int existingCount = retryInfo2 != null ? retryInfo2.getCount() : 0;
        RetryInfo it = retryInfo = new RetryInfo(existingCount + 1, reason);
        boolean bl = false;
        this.retryStateByEndpoint.put(endpoint, it);
        return retryInfo;
    }

    @Nullable
    public final RetryInfo get(@NotNull EndPointInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return this.retryStateByEndpoint.get(endpoint);
    }

    public final void clearRetryState(@NotNull EndPointInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.retryStateByEndpoint.remove(endpoint);
    }
}

