/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler.internal;

import com.dylibso.chicory.compiler.internal.CompilerOpCode;
import java.util.Arrays;
import java.util.stream.LongStream;

final class CompilerInstruction {
    public static final long[] EMPTY = new long[0];
    private final CompilerOpCode opcode;
    private final long[] operands;

    public CompilerInstruction(CompilerOpCode opcode) {
        this(opcode, EMPTY);
    }

    public CompilerInstruction(CompilerOpCode opcode, long ... operands) {
        this.opcode = opcode;
        this.operands = operands;
    }

    public CompilerOpCode opcode() {
        return this.opcode;
    }

    public LongStream operands() {
        return Arrays.stream(this.operands);
    }

    public int operandCount() {
        return this.operands.length;
    }

    public long operand(int index) {
        return this.operands[index];
    }

    public String toString() {
        if (this.operands.length == 0) {
            return this.opcode.toString();
        }
        if (this.operands.length == 1) {
            return String.valueOf((Object)this.opcode) + " " + this.operands[0];
        }
        return String.valueOf((Object)this.opcode) + " " + Arrays.toString(this.operands);
    }

    public long[] labelTargets() {
        switch (this.opcode) {
            case GOTO: 
            case IFEQ: 
            case IFNE: 
            case SWITCH: 
            case TRY_CATCH_BLOCK: {
                return this.operands;
            }
        }
        return EMPTY;
    }
}

